<?php 

namespace App\Http\Controllers\API;

use App\Http\Controllers\API\Vendor\OffersService;
use App\Http\Controllers\Controller;
use App\Models\QitafCouponVendors;
use Illuminate\Support\Facades\App;
use Spatie\OpeningHours\OpeningHours;

class APIVendorAuthController extends Controller
{
    private $vendor_uuid;
    private $vendor;
    public  $vendor_id;

    public $language;
    public $currency_code;

    public $deliveryOfferID = 0;
    public $deliveryCost    = 0;

    private $QitafToken = null;


    public $vendor_status;

    public function __construct()
    {
        // handler vendor Info
        $this->vendor_uuid = request()->vendor_uuid;
        $vendor = \App\Models\Vendor::where('link_name', $this->vendor_uuid)->first();
        if ( is_null($vendor) )
            return response()->json(['status' => false, 'message' => 'not found this vendor Please Contact with adminstrator']);
        
        $this->vendor    = $vendor;
        $this->vendor_id = $this->vendor->vendor_id;

        // handler currency
        $this->currency_code = $this->vendor->currency->code;

        // handler language
        $this->language = request()->header('language');
        $this->language = in_array($this->language, ['ar', 'en']) ? $this->language : 'ar';
        App::setLocale($this->language);


        $this->deliveryCost      = $this->getVendor()->delivery_cost;
        $offerVendorDeliveryCost = OffersService::offerVendorDeliveryCost($this->vendor_id);      
        if ( $offerVendorDeliveryCost != null )
        {
            $this->deliveryOfferID = $offerVendorDeliveryCost['offer_id'];
            $this->deliveryCost    = $offerVendorDeliveryCost['after_delivery_cost'];
        }


        // qitaf data
        $this->QitafToken = QitafCouponVendors::where('vendor_id', $this->vendor_id)->where('is_active', 1)->first();

        
        // handler Opening Hours
        $start = date('H:i', strtotime($this->vendor->wt_start_at));
        $end   = date('H:i', strtotime($this->vendor->wt_end_at));
        
        $vendorStatus = 'open';
        $opningHours  = OpeningHours::create([
          'monday'     => [ $start . '-' . $end ],
          'tuesday'    => [ $start . '-' . $end ],
          'wednesday'  => [ $start . '-' . $end ],
          'thursday'   => [ $start . '-' . $end ],
          'friday'     => [ $start . '-' . $end ],
          'saturday'   => [ $start . '-' . $end ],
          'sunday'     => [ $start . '-' . $end ],
        ]);
    
        if ( $opningHours->isClosed() )
            $vendorStatus = 'closed';

        $this->vendor_status = $this->getVendor()->status_open != 'busy' ? $vendorStatus : 'busy';
 
    }


    public function getCountry(){
        return $this->vendor->country;
    }


    public function getVendor(){
        return $this->vendor;
    }

    public function getQitafAuthToken(){
        return !is_null($this->QitafToken) ? $this->QitafToken : null;
    }


    // public function getMyFatoorahAuth(){
    //     return $this->vendor;
    // }

    public function getPayTabsAuth(){
        return $this->vendor;
    }

}
