<?php

namespace App\Http\Controllers\api;

use App\ad_company;
use App\Enterprise;
use App\enterprise_member;
use App\enterprise_user;
use App\Helpers\Messages;
use App\Helpers\SmsController;
use App\Http\Controllers\API\AuthBaseController;
use App\Http\Controllers\Controller;
use App\Http\Controllers\ControllersService;
use App\MobileValidation;
use App\Models\Enterprise as ModelsEnterprise;
use App\Models\Member;
use App\User;
use Facade\FlareClient\Http\Response;
// use Dotenv\Validator;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use phpseclib\Crypt\Random;
use Symfony\Component\Console\Input\Input;
use Symfony\Component\Mime\Header\Headers;

class UserApiAuthController extends AuthBaseController
{

    // public function login1(Request $request)
    // {
    //      $mobile = $request->get('mobile');
    //     //  $enterprise_profile = enterprise::where('serial_uuid')->first();
    //      $enterprise_profile = enterprise::where('serial_uuid',request()->header('enterprise_uuid'))->first();
    //      $user_enterprise = $enterprise_profile->user->where('mobile', $mobile)->first();
    //     $roles = [
    //         'mobile' => 'required|numeric|digits:10',
    //     ];
    //     if ($user_enterprise) {
    //         $validator = Validator::make($request->all(), $roles);
    //         if (!$validator->fails()) {
    //             $this->revokePreviousTokens($user_enterprise->id);
    //         //   return $this->generateToken($user_enterprise, 'LOGGED_IN_SUCCESSFULLY');
    //         } else {
    //             return ControllersService::generateValidationErrorMessage($validator->getMessageBag()->first());
    //         }
    //     } else {
    //     }
    //      }

         

    //     public function sendCode (Request $request)
    //     {
    //         $roles = [
    //             'mobile' => 'required|numeric|digits:10',
    //         ];
    //         $mobile = $request->get('mobile');
    //          $enterprise_profile = enterprise::where('serial_uuid')->first();
    //          $enterprise_profile = enterprise::where('serial_uuid',request()->header('enterprise_uuid'))->first();
    //          $user_enterprise = $enterprise_profile->user->where('mobile', $mobile)->first();
           
    //         if ($user_enterprise) {
    //             $validator = Validator::make($request->all(), $roles);
    //         if (!$validator->fails()) {
           
    //         $code = random_int(1000, 9999);
    //         $users = User::where('mobile', $user_enterprise->mobile)->first();
    //         if ($users){
    //             $users->code=$code;
    //             $users->save();
    //             return ControllersService::generateObjectSuccessResponse($code, 'We sent the code to your mobile');
    //         }
    //         } else {
    //             return ControllersService::generateValidationErrorMessage($validator->getMessageBag()->first());
    //         }
    //     }
    // }
//      public function login (Request $request)
//     {
//        $roles = [
//            'mobile' => 'required|numeric|digits:10',
//            'code' => 'required|numeric|digits:4',
//        ];
//        $mobile = $request->get('mobile');
//        $enterprise_profile = enterprise::where('serial_uuid')->first();
//         $enterprise_profile = enterprise::where('serial_uuid',request()->header('enterprise_uuid'))->first();
//         $user_enterprise = $enterprise_profile->user->where('mobile', $mobile)->first();
//         $user_enterprise_code =  $user_enterprise->where('code',$request->code)->first();
           
//             if ($user_enterprise) {
//                $validator = Validator::make($request->all(), $roles);
//                if (!$validator->fails()) {
//                    return $this->generateToken( $user_enterprise_code, 'LOGGED_IN_SUCCESSFULLY');
//                } else {
//            return ControllersService::generateValidationErrorMessage($validator->getMessageBag()->first());
//                }
//             return ControllersService::generateProcessResponse(true, 'LOGGED_IN_SUCCESSFULLY');
       
//         return $this->sendFailedLoginResponse($request);
//     }
//    }

     public function submitCode (Request $request)
    {
                // ارسال توكن

       $roles = [
           'code' => 'required|numeric|digits:4',
       ];

        $mobile = $request->get('phone');

        $enterprise_profile = ModelsEnterprise::where('api_key',request()->header('enterprise_uuid'))->first();

          $user_enterprise = $enterprise_profile->user->where('phone', $mobile)->first();
    
         $user_reg = Member::where('phone', $mobile)->first();
        $user_reg_enterprise_code =  $user_reg->code;


        if($user_enterprise) {
            if($user_enterprise->full_name==null){
            $validator = Validator::make($request->all(), $roles);
            if (!$validator->fails()) {
                $user_enterprise_code =  $user_enterprise->code;
            if($user_enterprise_code==$request->get('code')){
                return $this->generateToken( $user_enterprise, 'SUCCESS_AUTH');
                }else{
                    return ControllersService::generateProcessResponse(false, 'AUTH_CODE_ERROR');       
                    
                        }                
            } else {
            return ControllersService::generateValidationErrorMessage($validator->getMessageBag()->first());
            }    
        }else{
            $validator = Validator::make($request->all(), $roles);
            if (!$validator->fails()) {
                $user_enterprise_code =  $user_enterprise->code;

                if($user_enterprise_code==$request->get('code')){
            return $this->generateToken( $user_enterprise, 'LOGGED_IN_SUCCESSFULLY');
                }else{
                    return ControllersService::generateProcessResponse(false, 'AUTH_CODE_ERROR');       

                }
              } else {
                return ControllersService::generateValidationErrorMessage($validator->getMessageBag()->first());
                } 
            }

        }elseif(!($user_enterprise)){
            $validator = Validator::make($request->all(), $roles);
            if (!$validator->fails()) {
                if($user_reg_enterprise_code==$request->get('code')){
                  
            $user_enter_enterprise = new enterprise_member();
            $user_enter_enterprise->enterprise_id =  $enterprise_profile->id;
            $user_enter_enterprise->user_id =  $user_reg->id;
            $IsSave = $user_enter_enterprise->save();
            if($IsSave){
            return $this->generateToken( $user_reg, 'LOGGED_IN_SUCCESSFULLY');
        }
            }else{
                return ControllersService::generateProcessResponse(false, 'AUTH_CODE_ERROR');       
            }
           } else {
        return ControllersService::generateValidationErrorMessage($validator->getMessageBag()->first());
           }
        return ControllersService::generateProcessResponse(true, 'LOGGED_IN_SUCCESSFULLY');       
        }
   
}
    public function get_enterprise_user(Request $request)
    {
        //ارسال ان كان login or singup

        $roles = [
            'mobile' => 'required|numeric|digits:10',
        ];
          $mobile = $request->get('phone');
          $mobile_type = request()->header('mobile_type');
        $enterprise_profile = ModelsEnterprise::where('api_key', request()->header('enterprise_uuid'))->first();
          $user_enterprise = $enterprise_profile->user->where('phone', $mobile)->first();
         $user_reg = User::where('phone', $mobile)->first();

        if (!($user_reg)) {
        $validator = Validator::make($request->all(), $roles);
        if (!$validator->fails()) {
        $code = random_int(1000, 9999);
        // insert(['mobile' => $request->get('mobile') ,'code'=> bcrypt($code)])
        $new_user = new user();
        $new_user->mobile =  $mobile;
        $new_user->code= $code;
        $new_user->mobile_type = $mobile_type;
        $new_user->save();
        $user_enter_enterprise = new enterprise_member();
        $user_enter_enterprise->enterprise_id =  $enterprise_profile->id;
        $user_enter_enterprise->user_id = $new_user->id;
        $IsSave = $user_enter_enterprise->save();
        if($IsSave){
        return ControllersService::generateObjectSuccessResponse($code, 'We sent the code to your mobile');
    }
        } else {
        return ControllersService::generateValidationErrorMessage($validator->getMessageBag()->first());           
        }
  

        } elseif ($user_enterprise) {
            $roles = [
                'mobile' => 'required|numeric|digits:10',
            ];
            $validator = Validator::make($request->all(), $roles);
            if (!$validator->fails()) {
            $code = random_int(1000, 9999);
            $user = Member::where("phone", $mobile)->first();
            if ($user){
                $user->code=$code;
                $user->mobile_type = $mobile_type;
                $user->save();                   
                return ControllersService::generateObjectSuccessResponse($code, 'We sent the code to your mobile');
            } else {
                return ControllersService::generateValidationErrorMessage($validator->getMessageBag()->first());
            }
        }
        
        } elseif (!($user_enterprise)) {
            $roles = [
                'phone' => 'required|numeric|digits:10',
            ];
            $validator = Validator::make($request->all(), $roles);
            if (!$validator->fails()) {
                $code = random_int(1000, 9999);
                $users = Member::where('phone', $mobile)->first();
                if ($users){
                    $users->code= $code;
                    $users->mobile_type = $mobile_type;
                    $users->save();
                return ControllersService::generateObjectSuccessResponse($code, 'We sent the code to your mobile');
                }
            
            } else {
                return ControllersService::generateValidationErrorMessage($validator->getMessageBag()->first());
            }
        }
    }
//     public function submitCode_enterprise (Request $request)
//     {  
//         $roles = [
//         ];
//        $mobile = request()->header('mobile');
//        $enterprise_profile = enterprise::where('serial_uuid')->first();
//         $enterprise_profile = enterprise::where('serial_uuid',request()->header('enterprise_uuid'))->first();
//         $user_reg = User::where('mobile', $mobile)->first();
//         $user_enterprise = $enterprise_profile->user->where('mobile', $mobile)->first();
//         $user_enterprise_code =  $user_reg->where('code',$request->code)->first();
           
//             if (!($user_enterprise)) {
//                 $validator = Validator::make($request->all(), $roles);
//                 if (!$validator->fails()) {
//                 $user_enter_enterprise = new enterprise_user();
//                 $user_enter_enterprise->enterprise_id =  $enterprise_profile->id;
//                 $user_enter_enterprise->user_id = $user_reg->id;
//                 $IsSave = $user_enter_enterprise->save();
//                 if ($IsSave) {
//                    return $this->generateToken( $user_enterprise_code, 'LOGGED_IN_SUCCESSFULLY');
//                } else {
//             return ControllersService::generateValidationErrorMessage($validator->getMessageBag()->first());
//                }
//             return ControllersService::generateProcessResponse(true, 'LOGGED_IN_SUCCESSFULLY');
       
//         return $this->sendFailedLoginResponse($request);
//     }
//    }
//     }
    public function register(Request $request){
      
        $mobile = request()->header('phone');
        $enterprise_profile = ModelsEnterprise::where('api_key', request()->header('enterprise_uuid'))->first();
       
        
            $roles = [
                'full_name' => 'string|min:5|max:254',
                'email' => 'required|string|email|unique:users,email,',
                'gender' => 'required',
                'date_of_birth' => 'date_format:Y/m/d|before:today',
                'latitude' => 'required',
                'longitude' => 'required',
            ];
            $validator = Validator::make($request->all(), $roles);
            if (!$validator->fails()) {
                $user = new User();
                $user->country_id = $enterprise_profile->country_id;
                $user->full_name = $request->get('full_name');
                $user->email = $request->get('email');
                $user->phone = $mobile;
                $user->image = $request->file('image');
                $user->date_of_birth = $request->get('date_of_birth'); 
                $user->gender = $request->get('gender') == 'on' ? 'Male' : 'Female';
                $user->longitude = $request->get('longitude');
                $user->latitude = $request->get('latitude');
                $isSaved = $user->save();
                $enterprise = new enterprise_member();
                $enterprise->enterprise_id =  $enterprise_profile->id;
                $enterprise->user_id = Auth('user_api')->user()->id;;
                $$enterprise->save();
                if ($isSaved) {
                    return $this->generateToken($user, 'REGISTERED_SUCCESSFULLY');
                } else {
                    return ControllersService::generateProcessResponse(false, 'LOGIN_IN_FAILED');
                }
            } else {
                return ControllersService::generateValidationErrorMessage($validator->getMessageBag()->first());
            }

        
    }   
    public function update(Request $request)
    {
        $enterprise_profile = ModelsEnterprise::where('api_key',  request()->header('enterprise_uuid'))->first();

        $userId = $request->user('user_api')->id;
        $roles = [
            'full_name' => 'required|string|min:5|max:254',
            'email' => 'required|string|email|unique:users,email,' . $userId,
            'mobile' => 'required|numeric|digits:10|unique:users,mobile,' . $userId,
            'age' =>    'date_format:Y/m/d|before:today',
            'gender' => 'required|in:Male,Female',
            'image' => 'required',
            'country_id' => 'required',
            'latitude' => 'required',
                'longitude' => 'required',
        ];
        $validator = Validator::make($request->all(), $roles);

        if (!$validator->fails()) {
            $user = User::find($request->user('user_api')->id);
            $user->country_id = $enterprise_profile->country_id;
            $user->full_name = $request->get('full_name');
            $user->email = $request->get('email');
            $user->mobile = $request->get('mobile');
            $user->date_of_birth = $request->get('date_of_birth');    // get the request date
            $userimage = $request->file('image');
            $imageName = $request->file('image')->getClientOriginalName() . '' . $userimage->getExtension();
            $userimage->move('images/user', $imageName);
            $user->image = $imageName;
            $user->gender = $request->get('gender') == 'on' ? 'Male' : 'Female';
            $user->longitude = $request->get('longitude');
            $user->latitude = $request->get('latitude');
            $isUpdated = $user->save();
            if ($isUpdated) {
                return ControllersService::generateObjectSuccessResponse($user, Messages::getMessage('USER_UPDATED_SUCCESS'));
            } else {
                return ControllersService::generateObjectSuccessResponse($user, Messages::getMessage('USER_UPDATED_FAILED'));
            }
        } else {
            return ControllersService::generateValidationErrorMessage($validator->getMessageBag()->first());
        }
    }

    private function generateToken($user, $message)
    {
        $tokenResult = $user->createToken('News-User');
        $token = $tokenResult->accessToken;
        $user->setAttribute('token', $token);
        return response()->json([
            'status' => true,
            'message' => Messages::getMessage($message),
            'data' => $user,
        ]);
    }
}
