<?php

namespace App\Http\Controllers\API\Vendor;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Controllers\API\APIVendorAuthController;
use App\Models\CustomersAddresses;
use App\Http\Controllers\API\ControllersService;
use Illuminate\Support\Facades\Validator;

class AddressController extends APIVendorAuthController
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $addresses = CustomersAddresses::where('vendor_id', $this->vendor_id)->where('member_id', auth()->user()->member_id)->get();
        if ( is_null($addresses) OR count($addresses) ==  0)
            $addresses = null;

        return ControllersService::generateNewResponse(true, 200, 'REQUEST_SUCCESS', ['addresses' => $addresses]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $roles = [
            'address_label' => 'required|string',
            'address' => 'required|string',
            'lat' => 'required|string',
            'long' => 'required|string',
            'storey_number' => 'required|numeric',
            'apartment_number' => 'required|numeric',
            //'password' => 'required|min:6',
        ];
        $validator = Validator::make($request->all(), $roles);
        if ($validator->fails())
            return ControllersService::generateNewResponse(false, 400, 'NO_AUTH_CODE', $validator->getMessageBag()->first());



        $newAddress = new CustomersAddresses();
        $newAddress->member_id        = auth()->user()->member_id;
        $newAddress->vendor_id        = $this->vendor_id;
        $newAddress->ent_id           = 0;
        $newAddress->label            = $request->address_label;
        $newAddress->address          = $request->address;
        $newAddress->lat              = $request->lat;
        $newAddress->long             = $request->long;
        $newAddress->storey_number    = $request->storey_number;
        $newAddress->apartment_number = $request->apartment_number;
        $newAddress->save();

        return ControllersService::generateNewResponse(true, 200, 'REQUEST_SUCCESS', ['address' => $newAddress]);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($vendor, $id)
    {
        
        $address = CustomersAddresses::where('id', $id)->where('vendor_id', $this->vendor_id)->where('member_id', auth()->user()->member_id)->first();
        if ( is_null($address) OR empty($address))
            $address = null;

        return ControllersService::generateNewResponse(true, 200, 'REQUEST_SUCCESS', $address);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $vendor, $id)
    {
        $roles = [
            'address_label' => 'required|string',
            'address' => 'required|string',
            'lat' => 'required|string',
            'long' => 'required|string',
            'storey_number' => 'required|numeric',
            'apartment_number' => 'required|numeric',
        ];
        $validator = Validator::make($request->all(), $roles);
        if ($validator->fails())
            return ControllersService::generateNewResponse(false, 400, 'NO_AUTH_CODE', $validator->getMessageBag()->first());



        $newAddress = CustomersAddresses::find($id);
        if ( is_null($newAddress) OR empty($newAddress) )
            return ControllersService::generateNewResponse(false, 404, 'ITEM_NOT_FOUND', ['address' => null]);


        $newAddress->label            = $request->address_label;
        $newAddress->address          = $request->address;
        $newAddress->lat              = $request->lat;
        $newAddress->long             = $request->long;
        $newAddress->storey_number    = $request->storey_number;
        $newAddress->apartment_number = $request->apartment_number;
        $newAddress->save();

        return ControllersService::generateNewResponse(true, 200, 'UPDATE_SUCCESS', ['address' => $newAddress]);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($vendor, $id)
    {
        $newAddress = CustomersAddresses::find($id);
        if ( is_null($newAddress) OR empty($newAddress) )
            return ControllersService::generateNewResponse(false, 404, 'ITEM_NOT_FOUND', ['address' => null]);

        $newAddress->delete();
        return ControllersService::generateNewResponse(true, 200, 'DELETE_SUCCESS');
    }
}
