<?php

namespace App\Http\Controllers\API\Vendor;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Controllers\API\APIVendorAuthController;
use App\Models\CustomersAddresses;
use App\Http\Controllers\API\ControllersService;
use App\Models\BasketOrdersMain;
use App\Models\BasketOrdersProducts;
use App\Models\BasketOrdersProductsAddons;
use App\Models\Product;
use App\Models\ProductAddon;
use Illuminate\Support\Facades\Validator;

class BasketController extends APIVendorAuthController
{
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        // get basket main order for this user
        $basketOrder = BasketOrdersMain::where('rest_id', $this->vendor_id)->where('user_id', auth()->user()->member_id)->where('is_done', 0)->first();
        if( is_null($basketOrder) )
          return ControllersService::generateNewResponse(true, 200, 'ITEM_NOT_FOUND', null);

        $dataReturn = [];

        $basketProducts = BasketOrdersProducts::where('order_id', $basketOrder->order_id)->get();
        if ( is_null($basketProducts) )
            return ControllersService::generateNewResponse(true, 200, 'ITEM_NOT_FOUND', null);


        $dataReturn = $this->basketProductsHandler($basketProducts);
        $dataReturn['order_id'] =  $basketOrder->order_id;
        
/*
        foreach ($basketProducts as $key => $basketProduct)
        {

            $productInfo = Product::where('product_id', $basketProduct->meal_id)->first();

            $dataReturn['products'][$key]['basket_product_id'] =  $basketProduct->basket_id;
            $dataReturn['products'][$key]['custom_addons'] =  $basketProduct->custom_addons;
            $dataReturn['products'][$key]['product_id']    =  $basketProduct->meal_id;

            $dataReturn['products'][$key]['product_name'] =  $productInfo->name;


            $dataReturn['products'][$key]['product_image'] =  $productInfo->image;

            $dataReturn['products'][$key]['quantity']   =  $basketProduct->meal_quantity;

            $dataReturn['products'][$key]['one_product_price'] =  $basketProduct->one_meal_price;
            $dataReturn['products'][$key]['product_addons_price'] =  $basketProduct->meal_addons_price;
            $dataReturn['products'][$key]['final_price'] =  $basketProduct->final_price;

            // get offers;
            $dataReturn['products'][$key]['product_offer'] = null;
            if ( $basketProduct->offer_id != 0 )
            {
                $dataReturn['products'][$key]['product_offer'] = OffersService::offerProduct($this->vendor_id, $basketProduct->meal_id);
            }


            $addons = BasketOrdersProductsAddons::where('order_basket_id', $basketProduct->basket_id)->get();
            if ( !is_null($addons) )
            {
                foreach ($addons as $keyAddon => $addon)
                {

                    $addonInfo = ProductAddon::where('addon_id', $addon->addon_id)->where('addon_is_active', 1)->first();
                    if ( is_null($addonInfo) or empty($addonInfo) )
                        continue;

                    $dataReturn['products'][$key]['addons'][$keyAddon]['addon_id'] = $addon->addon_id;
                    $dataReturn['products'][$key]['addons'][$keyAddon]['addon_price'] = $addon->addon_price;
                    $dataReturn['products'][$key]['addons'][$keyAddon]['addon_full_price'] = $addon->addons_full_price;
                    $dataReturn['products'][$key]['addons'][$keyAddon]['addon_name'] = $addonInfo->name;
                }
            }else{
                $dataReturn['products'][$key]['addons'] = null;
            }

        }
*/

        if ( count($basketProducts) == 0 )
          $dataReturn = null;

        return ControllersService::generateNewResponse(true, 200, 'REQUEST_SUCCESS', $dataReturn);
    }


    public function basketProductsHandler($basketProducts)
    {
        $dataReturn['products_price'] = 0;
            

        foreach ($basketProducts as $key => $basketProduct)
        {
            $dataReturn['products_price'] += $basketProduct->final_price;

            $productInfo = Product::where('product_id', $basketProduct->meal_id)->first();

            $dataReturn['products'][$key]['basket_product_id'] =  $basketProduct->basket_id;
            $dataReturn['products'][$key]['custom_addons'] =  $basketProduct->custom_addons;
            $dataReturn['products'][$key]['product_id']    =  $basketProduct->meal_id;

            $dataReturn['products'][$key]['product_name'] =  $productInfo->name;


            $dataReturn['products'][$key]['product_image'] =  $productInfo->image;

            $dataReturn['products'][$key]['quantity']   =  $basketProduct->meal_quantity;

            $dataReturn['products'][$key]['one_product_price'] =  $basketProduct->one_meal_price;
            $dataReturn['products'][$key]['product_addons_price'] =  $basketProduct->meal_addons_price;
            $dataReturn['products'][$key]['final_price'] =  $basketProduct->final_price;

            // get offers;
            $dataReturn['products'][$key]['product_offer'] = null;
            if ( $basketProduct->offer_id != 0 )
            {
                $dataReturn['products'][$key]['product_offer'] = OffersService::offerProduct($this->vendor_id, $basketProduct->meal_id);
            }


            $addons = BasketOrdersProductsAddons::where('order_basket_id', $basketProduct->basket_id)->get();
            if ( !is_null($addons) )
            {
                foreach ($addons as $keyAddon => $addon)
                {

                    $addonInfo = ProductAddon::where('addon_id', $addon->addon_id)->where('addon_is_active', 1)->first();
                    if ( is_null($addonInfo) or empty($addonInfo) )
                        continue;

                    $dataReturn['products'][$key]['addons'][$keyAddon]['addon_id'] = $addon->addon_id;
                    $dataReturn['products'][$key]['addons'][$keyAddon]['addon_price'] = $addon->addon_price;
                    $dataReturn['products'][$key]['addons'][$keyAddon]['addon_full_price'] = $addon->addons_full_price;
                    $dataReturn['products'][$key]['addons'][$keyAddon]['addon_name'] = $addonInfo->name;
                }
            }else{
                $dataReturn['products'][$key]['addons'] = null;
            }

        }

        return $dataReturn;
    }



    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $roles = [
            'product_id'       => 'required|numeric',
            'custom_addons'    => 'sometimes|required|string',
            'product_quantity' => 'required|numeric',
        ];
        $validator = Validator::make($request->all(), $roles);
        if ($validator->fails())
            return ControllersService::generateNewResponse(false, 400, 'NO_AUTH_CODE', $validator->getMessageBag()->first());

        $quantity = $request->product_quantity == 0 ? 1 : $request->product_quantity;


        // get product info
        $product = Product::where('product_id', $request->product_id)->where('status', 1)->first();
        if ( is_null($product) )
            return ControllersService::generateNewResponse(false, 400, 'ITEM_NOT_FOUND');

        // get basket main order for this user
        $basketOrder = BasketOrdersMain::firstOrCreate([
            'rest_id' => $this->vendor_id,
            'user_id' => auth()->user()->member_id,
            'is_done' => 0,
        ]);
        $basket_order_id = $basketOrder->order_id;

        // store this product info
        $basketProduct = new BasketOrdersProducts();
        $basketProduct->order_id  = $basket_order_id;
        $basketProduct->member_id  = auth()->user()->member_id;
        $basketProduct->rest_id  = $this->vendor_id;
        $basketProduct->meal_id  = $product->product_id;
        $basketProduct->meal_size_id  = 0;
        $basketProduct->custom_addons  = $request->custom_addons;
        $basketProduct->meal_quantity  = $quantity;
        $basketProduct->save();

        // Store addons on this product
        $addonsFullPrice = 0;
        $addons = null;
        if (!empty($request->product_addons))
        {
            $addons = json_decode($request->product_addons, true);
            if ( is_array($addons) && ! empty($addons) )
            {
                foreach($addons['addons'] as $addon)
                {
                    // get addons info
                    $addonInfo = ProductAddon::where('addon_id', $addon)->where('addon_is_active', 1)->first();
                    if ( is_null($addonInfo) or empty($addonInfo) )
                        continue;

                    $basketProductAddon = new BasketOrdersProductsAddons();
                    $basketProductAddon->order_basket_id  = $basketProduct->basket_id;
                    $basketProductAddon->addon_id = $addonInfo->addon_id;
                    $basketProductAddon->addon_price = $addonInfo->addon_price;
                    $basketProductAddon->addons_full_price = $quantity * $addonInfo->addon_price;

                    $addonsFullPrice += $basketProductAddon->addons_full_price;

                    $basketProductAddon->save();
                }
            }
        }

        // get offers on this product
        $offerProduct    = OffersService::offerProduct($this->vendor_id, $product->product_id);
        $offerID         = 0;
        $oneProductPrice = $product->meal_price;


        if ( ! is_null($offerProduct) && ! empty($offerProduct) && is_array($offerProduct))
        {
            $offerID = $offerProduct['offer_id'];
            if ($offerProduct['offer_type'] == 'products_discount')
                $oneProductPrice = $offerProduct['offer_new_price'];
        }

        $ProductPrice = $oneProductPrice * $quantity;
        $basketProduct->offer_id           = $offerID;
        $basketProduct->one_meal_price     = $oneProductPrice;
        $basketProduct->meal_addons_price  = $addonsFullPrice;
        $basketProduct->final_price        = $ProductPrice + $addonsFullPrice;
        $basketProduct->save();

        return ControllersService::generateNewResponse(true, 200, 'REQUEST_SUCCESS');
    }


    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $vendor, $id)
    {
        $roles = [
            'new_quantity'       => 'required|numeric|min:1',
        ];

        $validator = Validator::make($request->all(), $roles);
        if ($validator->fails())
            return ControllersService::generateNewResponse(false, 400, 'UPDATE_FAILED', $validator->getMessageBag()->first());

        $orderBasketProduct = BasketOrdersProducts::where('basket_id', $id)->where('rest_id', $this->vendor_id)->where('member_id', auth()->user()->member_id)->first();
        if ( is_null($orderBasketProduct) )
            return ControllersService::generateNewResponse(false, 400, 'UPDATE_FAILED');


        $addons = BasketOrdersProductsAddons::where('order_basket_id', $orderBasketProduct->basket_id)->get();

        // handle price
        $new_quantity  = (int) $request->new_quantity;
        $product_price = $orderBasketProduct->one_meal_price * $new_quantity;

        // handler all addons
        $allAddonsPrices   = 0;
        if ( ! empty( $addons ) )
        {
            foreach ($addons as $addon)
            {
                $fulladdonsprice  = $addon->addon_price  * $new_quantity;
                $allAddonsPrices += $fulladdonsprice;

                $addon->addons_full_price = $fulladdonsprice;
                $addon->save();
            }
        }


        $orderBasketProduct->meal_quantity     = $new_quantity;
        $orderBasketProduct->meal_addons_price = $allAddonsPrices;
        $orderBasketProduct->final_price       = $product_price + $allAddonsPrices;
        $orderBasketProduct->save();

        return ControllersService::generateNewResponse(true, 200, 'UPDATE_SUCCESS');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($vendor, $id)
    {
        switch ($id) {
            case 'all':

                $orderBasketProducts = BasketOrdersProducts::where('rest_id', $this->vendor_id)->where('member_id', auth()->user()->member_id)->get();

                foreach ($orderBasketProducts as $orderBasketProduct)
                {
                    BasketOrdersProductsAddons::where('order_basket_id', $orderBasketProduct->basket_id)->delete();
                }

                BasketOrdersProducts::where('rest_id', $this->vendor_id)->where('member_id', auth()->user()->member_id)->delete();
                break;

            default:
            BasketOrdersProducts::where('rest_id', $this->vendor_id)
                ->where('member_id', auth()->user()->member_id)
                ->where('basket_id', $id)
                ->delete();
            BasketOrdersProductsAddons::where('order_basket_id', $id)->delete();
                break;
        }

        return ControllersService::generateNewResponse(true, 200, 'DELETE_SUCCESS');
    }
}
