<?php
namespace App\Http\Controllers\API\Vendor;

use App\Http\Controllers\API\APIVendorAuthController;
use App\Http\Controllers\API\ControllersService;
use App\Models\Branch;


class BranchesController extends APIVendorAuthController
{

  public function index()
  {
    $resonseData   = [];
    $branches      = null;
    $fetchBranches = Branch::with('city')->with('neighborhood')->where('vendor_id', $this->vendor_id)->where('status', '1')->get();

    $type = request('type');
    $type = in_array($type, ['delivery', 'pickup']) ? $type : 'delivery';

    $mLat = request('latitude');
    $mLng = request('longitude');

    if ( ! is_null($fetchBranches) )
    {
      foreach ($fetchBranches as $key => $branch)
      {
        $branches[$key]['branch_id']          = $branch->branch_id;
        $branches[$key]['vendor_id']          = $branch->vendor_id;
        $branches[$key]['branch_name']        = $branch->name;
        $branches[$key]['longitude']          = $branch->longitude;
        $branches[$key]['latitude']           = $branch->latitude;
        $branches[$key]['max_area_delivery']  = $branch->max_area_delivery;
        $branches[$key]['phone_code']         = $branch->phone_code;
        $branches[$key]['branch_whatsapp']    = $branch->branch_whatsapp;
        $branches[$key]['branch_phone']       = $branch->branch_phone;
        $branches[$key]['branch_address']     = ! empty($branch->branch_address) ? $branch->branch_address : null;
        $branches[$key]['city_name']          = $branch->city->name ?? null;
        $branches[$key]['neighborhood_name']  = $branch->neighborhood->name ?? null;
        $branches[$key]['distance']  = number_format($this->distance($branch->latitude, $branch->longitude, $mLat, $mLng), 2,'.','');
        $branches[$key]['distance_type']  = 'KM';
        
        if ( $type == 'delivery' && $branches[$key]['distance'] != 0 && $branches[$key]['max_area_delivery'] != 0 && $branches[$key]['distance'] > $branches[$key]['max_area_delivery'])
            unset($branches[$key]);
      }
    }

    $resonseData['branches'] = $branches;

    return ControllersService::generateNewResponse(true, 200, 'REQUEST_SUCCESS', $resonseData);
  }

  private function distance($lat1, $lon1, $lat2, $lon2, $unit = 'k')
  {
      if (!is_numeric($lat1) || !is_numeric($lon1) || !is_numeric($lat2) || !is_numeric($lon2))
          return "0";
      $theta = $lon1 - $lon2;
      $dist = sin(deg2rad($lat1)) * sin(deg2rad($lat2)) + cos(deg2rad($lat1)) * cos(deg2rad($lat2)) * cos(deg2rad($theta));
      $dist = acos($dist);
      $dist = rad2deg($dist);
      $miles = $dist * 60 * 1.1515;
      $unit = strtoupper($unit);

      if ($unit == "K") {
          return ($miles * 1.609344);
      } else if ($unit == "N") {
          return ($miles * 0.8684);
      } else {
          return $miles;
      }
  }


}
