<?php

namespace App\Http\Controllers\API\Vendor;

use Illuminate\Http\Request;
use App\Http\Controllers\API\APIVendorAuthController;
use App\Http\Controllers\API\ControllersService;

use App\Http\Controllers\API\Vendor\Repository\CouponService;
use App\Models\BasketOrdersMain;

class CouponController extends APIVendorAuthController
{

    protected $coupon_code,
              $type,
              $total_price,
              $tip,
              $delivery_cost = 0;


    public function __construct(Request $request)
    {
        parent::__construct();


        $this->coupon_code = $request->code_coupon;
        $this->type        = in_array($request->type, ['pickup', 'delivery']) ? $request->type : 'pickup';
        $this->tip         = $request->tip;

        // handle delivery cost
        if ( $this->type == 'delivery' )
            $this->delivery_cost = $this->deliveryCost; // from vendor auth class
    }



    public function checkSystem()
    {
      if ($this->handlerOrderTotalPrice() === null)
        return ControllersService::generateNewResponse(true, 200, 'COUPON_BASKET_IS_EMPTY', []);

        $options = [
            'couponCode'    => $this->coupon_code,
            'totalPrice'    => $this->total_price,
            'viaQitaf'      => false,
            'request'       => false,
            'delivery_cost' => $this->delivery_cost,
            'tip'           => $this->tip,
            'typeReceive'   => $this->type,
            'order_id'      => 0,
        ];
        $CouponService = new CouponService($options);
        $CouponService = $CouponService->check();


        return ControllersService::generateNewResponse($CouponService['statusCoupon'], $CouponService['statusCode'], $CouponService['statusMsg'], $CouponService['data']);
    }

    public function checkQitaf(){

        if ($this->getQitafAuthToken() === null OR empty($this->getQitafAuthToken()->token) OR empty($this->getQitafAuthToken()->user_key))
            return ControllersService::generateNewResponse(false, 400, 'QITAF_AUTH_ERROR', []);

        if ($this->handlerOrderTotalPrice() === null)
          return ControllersService::generateNewResponse(true, 200, 'COUPON_BASKET_IS_EMPTY', []);

        $options = [
            'couponCode'    => $this->coupon_code,
            'totalPrice'    => $this->total_price,
            'viaQitaf'      => true,
            'request'       => false,
            'delivery_cost' => $this->delivery_cost,
            'tip'           => $this->tip,
            'typeReceive'   => $this->type,
            'order_id'      => 0,
        ];

        $CouponService = new CouponService($options);
        $CouponService = $CouponService->check();


        return ControllersService::generateNewResponse($CouponService['statusCoupon'], $CouponService['statusCode'], $CouponService['statusMsg'], $CouponService['data']);
    }

    private function handlerOrderTotalPrice()
    {
        // handler Data get Full Price
        $orderBasket = BasketOrdersMain::where('rest_id', $this->vendor_id)->where('user_id', auth()->user()->member_id)->where('is_done', 0)->first();
        if ( is_null($orderBasket) )
          return null;

        $price = 0;
        foreach ($orderBasket->basketProducts as $product)
            $price += $product->final_price;

        $this->total_price = $price;


        return true;
    }

}
