<?php
namespace App\Http\Controllers\API\Vendor;

use App\Http\Controllers\API\APIVendorAuthController;
use App\Http\Controllers\API\ControllersService;
use App\Http\Controllers\API\Vendor\OffersService;
use App\Models\Banner;
use App\Models\Contact;
use App\Models\IntroductionApp;
use App\Models\Order;
use App\Models\Product;
use App\Models\ProductCategory;
use App\Models\SocialMedia;
use App\Models\Vendor;
use Carbon\Carbon;
use Spatie\OpeningHours\OpeningHours;
use App\Models\spes_slider;
use App\Models\spesSlider_product;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class HomeController extends APIVendorAuthController
{

  public function index()
  {

    $resonseData = [];

    $banners = null;
    // $fetchBanners = Banner::where('vendor_id', $this->vendor_id)->whereDate('to', '>=', Carbon::now()->format('Y-m-d H:i:s') )->get();
    // date problem
    $fetchBanners = Banner::where('vendor_id', $this->vendor_id)->where('display_at', 'home')->get();

    if ( ! is_null($fetchBanners) )
    {
      foreach ($fetchBanners as $key => $banner)
      {
        $banners[$key]['image']    = $banner->imageUrl;
        $banners[$key]['target']   = $banner->type;

        switch ($banner->type)
        {
          case 'link':
            $banners[$key]['link'] = $banner->value;
            break;

          case 'product':
            $banners[$key]['product_id'] = $banner->value;
            $product = Product::find($banner->value);

            if ( ! empty($product) )
            {
              $banners[$key]['product']['id'] = $product->product_id;
              $banners[$key]['product']['name'] = $product->name;
              $banners[$key]['product']['image'] = $product->image;
            }

            break;

          case 'rest_id':
            $banners[$key]['vendor'] = $banner->value;
            break;

          case 'promo_code':
            $banners[$key]['promo_code'] = $banner->value;
            break;

          case 'image_only':
            $banners[$key]['image_only'] = true;
            break;

        }
      }
    }

    $resonseData['slider'] = $banners;

    // handler best products
    $BestProducts = null;
    $products     = Order::selectRaw('count(order_pool.meal_quantity) as counter,  order_pool.meal_id')
                      ->where('orders.vendor_id', $this->vendor_id)
                      ->join('order_pool', 'orders.order_id', '=', 'order_pool.order_id', 'inner')
                      ->groupBy('meal_id')->orderBy('counter', 'desc')->limit(15)->get();
    if ( ! is_null($products) )
    {
      foreach ($products as $key => $product)
      {
        $originProduct = Product::find($product->meal_id);
         $BestProducts[$key]['product_id']    = $product->meal_id;
        $BestProducts[$key]['purchase_number']       = $product->counter;
        $BestProducts[$key]['product_name']  = $originProduct->name;
        $BestProducts[$key]['product_image'] = $originProduct->image;
        $BestProducts[$key]['product_price_currency'] = $this->currency_code;

        // start offer prduct handler
        $BestProducts[$key]['product_offer']  = OffersService::offerProduct($this->vendor_id,$product->meal_id);
        if ( $BestProducts[$key]['product_offer'] != null && $BestProducts[$key]['product_offer']['offer_type'] == 'products_discount' )
        {
          $BestProducts[$key]['product_price_before'] = $originProduct->price;
          $BestProducts[$key]['product_price']  = $BestProducts[$key]['product_offer']['offer_new_price'];

        }else{
          $BestProducts[$key]['product_price_before'] = null;
          $BestProducts[$key]['product_price'] = $originProduct->price;
        }
        // end of offer prduct handler
      }
    }

    $resonseData['most_requested'] = $BestProducts;

 $spes_sliders = null;
    $spes_slider = spes_slider::where('vendor_id', $this->vendor_id)->with('productApi')->orderBy('sort', 'asc')->get();
    foreach ($spes_slider as $key => $intro) {
      $spes_sliders[$key]['id']         = $intro->id;
      $spes_sliders[$key]['sliderName']       = $intro->sliderName;
      $spes_sliders[$key]['viewType']      = $intro->viewType;
      $spes_sliders[$key]['color']       = $intro->color;
      $spes_sliders[$key]['sort']       = $intro->sort;
      $spes_sliders[$key]['product']       = $intro->productApi;

    }

    $resonseData['spes_slider'] = $spes_sliders;
    return ControllersService::generateNewResponse(true, 200, 'REQUEST_SUCCESS', $resonseData);
  }
  // // home request { slider & Most Products Buys 15 Product }


  public function info()
  {
    $resonseData = [];
    $resonseData['vendor_id']   = $this->getVendor()->vendor_id;
    $resonseData['vendor_name'] = $this->getVendor()->name;
    $resonseData['vendor_desc'] = $this->getVendor()->desc;

    $resonseData['vendor_image']     = $this->getVendor()->logo;
    $resonseData['vendor_cover_img'] = $this->getVendor()->image_cover;

    $resonseData['vendor_currency'] = $this->currency_code;

    $resonseData['can_delivery']    = $this->getVendor()->can_delivery == 1 ? true : false;

    $resonseData['delivery_cost_offer']   = OffersService::offerVendorDeliveryCost($this->getVendor()->vendor_id);
    if ( $resonseData['delivery_cost_offer'] != null )
      $resonseData['delivery_cost']   = $resonseData['delivery_cost_offer']['after_delivery_cost'];
    else
      $resonseData['delivery_cost']   = $this->getVendor()->delivery_cost;

      $resonseData['currency_code']   = $this->currency_code;

    $resonseData['delivery_time']   = $this->getVendor()->delivery_time;
    $resonseData['can_pickup']      = $this->getVendor()->can_pickup == 1 ? true : false;

    $resonseData['wt_start_at'] = $this->getVendor()->wt_start_at;
    $resonseData['wt_end_at']   = $this->getVendor()->wt_end_at;
    $resonseData['minimum_charge']   = $this->getVendor()->minimum_charge;

    // handler Opening Hours
    // $start = date('H:i', strtotime($resonseData['wt_start_at']));
    // $end   = date('H:i', strtotime($resonseData['wt_end_at']));

    // $vendorStatus = 'open';
    // $opningHours  = OpeningHours::create([
    //   'monday'     => [ $start . '-' . $end ],
    //   'tuesday'    => [ $start . '-' . $end ],
    //   'wednesday'  => [ $start . '-' . $end ],
    //   'thursday'   => [ $start . '-' . $end ],
    //   'friday'     => [ $start . '-' . $end ],
    //   'saturday'   => [ $start . '-' . $end ],
    //   'sunday'     => [ $start . '-' . $end ],
    // ]);

    // if ( $opningHours->isClosed() )
    //     $vendorStatus = 'closed';

    $resonseData['status_open'] = $this->getVendor()->status_open;
    // end vendor info

    // show all products categories
    $resonseData['menu_categories'] = null;
    $categories = ProductCategory::where('vendor_id', $this->vendor_id)->where('category_status', 1)->orderBy('category_order', 'asc')->get();
    if ( ! is_null($categories) )
    {
      foreach ($categories as $key => $category)
      {
        $resonseData['menu_categories'][$key]['category_id']     = $category->category_id;
        $resonseData['menu_categories'][$key]['category_name']   = $category->name;
        $resonseData['menu_categories'][$key]['category_image']  = $category->image;
        $resonseData['menu_categories'][$key]['category_sort']   = $category->category_order;
        $resonseData['menu_categories'][$key]['category_status'] = $category->category_status;
      }
    }

    // return response
    return ControllersService::generateNewResponse(true, 200, 'REQUEST_SUCCESS', $resonseData);
  }


  public function introApp()
  {
    $resonseData = [];

    $introApp = null;
    $introImages = IntroductionApp::where('vendor_id', $this->vendor_id)->where('is_active', 1)->orderBy('sort', 'asc')->get();
    if ( ! is_null($introImages) )
    {
      foreach ($introImages as $key => $intro)
      {
        $introApp[$key]['id']         = $intro->id;
        $introApp[$key]['text']       = $intro->name;
        $introApp[$key]['image']      = $intro->image_url;
        $introApp[$key]['sort']       = $intro->sort;
      }
    }
    $resonseData['intro_app'] = $introApp;
    return ControllersService::generateNewResponse(true, 200, 'REQUEST_SUCCESS', $resonseData);
  }


  public function contactUs(Request $request)
  {
        $roles = [
          'phone' => 'required|numeric|digits:12',
          'msg_title' => 'required|string',
          'email' => 'required|email',
          'msg_details' => 'required|string',
      ];
      $validator = Validator::make($request->all(), $roles);

      // if error in validation
      if ($validator->fails())
          return ControllersService::generateNewResponse(false, 400, 'NO_AUTH_CODE',$validator->getMessageBag()->first());

      $Contact = new Contact();
      $Contact->MessageTitle   =  $request->msg_title;
      $Contact->MessageContent =  $request->msg_details;
      $Contact->MessageStatus  =  0;
      $Contact->MessageEmail   =  $request->email;
      $Contact->MessagePhone   =  $request->phone;
      $Contact->vendor_id      =  $this->vendor_id;
      if (auth()->check()) {
        $Contact->member_id      =  auth()->user()->member_id;
      }
      $Contact->save();

      return ControllersService::generateNewResponse(true, 200, 'SUPPORT_MSG_SENT',[]);

  }

  public function socialMediaInfo()
  {
    $resonseData = SocialMedia::select('facebook', 'twitter', 'whatsapp', 'phone', 'website', 'instagram', 'snapchat', 'youtube')->where('vendor_id', $this->vendor_id)->where('is_active', 1)->first();
    return ControllersService::generateNewResponse(true, 200, 'REQUEST_SUCCESS', $resonseData);
  }

  public function slider(){
    $resonseData = [];

    $spes_slider = null;
    $spes_slider = spes_slider::where('vendor_id', $this->vendor_id)->with('product')->orderBy('sort', 'asc')->get();
    foreach ($spes_slider as $key => $intro) {
      $introApp[$key]['id']         = $intro->id;
      $introApp[$key]['sliderName']       = $intro->sliderName;
      $introApp[$key]['viewType']      = $intro->viewType;
      $introApp[$key]['color']       = $intro->color;
      $introApp[$key]['sort']       = $intro->sort;

    }



  $resonseData['spes_slider'] = $introApp;
  return ControllersService::generateNewResponse(true, 200, 'REQUEST_SUCCESS', $spes_slider);
  }


}
