<?php
namespace App\Http\Controllers\API\Vendor;

use App\Http\Controllers\API\APIVendorAuthController;
use App\Http\Controllers\API\ControllersService;
use App\Http\Controllers\API\Vendor\OffersService;
use App\Models\Banner;
use App\Models\Product;
use Illuminate\Support\Facades\Request;

class MenuController extends APIVendorAuthController
{

  // reqest to show all products by category id
  public function showMenuByCatID()
  {
    $category_id = (int) request('category_id');

    if ( $category_id == 0 )
      return ControllersService::generateNewResponse(false, 400, 'NOT_FOUND');

    $resonseData = [];

    $Banner = Banner::where('display_at', 'category')->where('display_category_id', $category_id)->orderBy('id', 'desc')->get();
    $resonseData['category_slider'] = $Banner->map(function ($banner)
    {
       $banner->image = url($banner->image);
       return $banner;
    });

    $resonseData['products_menu'] = null;
    $productsMenu = Product::where('vendor_id', $this->vendor_id)->where('category_id', $category_id)->where('status', 1)->get();
    if ( ! is_null($productsMenu) )
    {
      foreach ($productsMenu as $key => $product)
      {
        $resonseData['products_menu'][$key]['product_id']     = $product->product_id;
        $resonseData['products_menu'][$key]['product_name']   = $product->name;
        $resonseData['products_menu'][$key]['product_desc']   = $product->desc;
        $resonseData['products_menu'][$key]['image']          = url($product->meal_image);
        $resonseData['products_menu'][$key]['price_currency'] = $this->currency_code;

        // start offer prduct handler
        $resonseData['products_menu'][$key]['product_offer']  = OffersService::offerProduct($this->vendor_id,$product->product_id);
        if ( $resonseData['products_menu'][$key]['product_offer'] != null && $resonseData['products_menu'][$key]['product_offer']['offer_type'] == 'products_discount' )
        {
          $resonseData['products_menu'][$key]['product_price_before'] = $product->price;
          $resonseData['products_menu'][$key]['product_price']  = $resonseData['products_menu'][$key]['product_offer']['offer_new_price'];

        }else{
          $resonseData['products_menu'][$key]['product_price_before'] = null;
          $resonseData['products_menu'][$key]['product_price'] = $product->price;
        }
        // end of offer prduct handler
      }
    }
    return ControllersService::generateNewResponse(true, 200, 'REQUEST_SUCCESS', $resonseData);
  }

  // reqest to show product info & Additions




}
