<?php 

namespace App\Http\Controllers\API\Vendor;

use App\Models\OfferProduct;
use App\Models\OfferVendorsDelivery;
use App\Models\Product;

class OffersService
{

    public static function offerVendorDeliveryCost($vendor_id)
    {
        $offer = OfferVendorsDelivery::join('offers', 'offer_id', '=', 'offers.id')
            ->where('offers.end_time', '>=', \Carbon\Carbon::today())
            ->where('offer_vendors_delivery.vendor_id', $vendor_id)
            ->where('offer_general_type', 'discount_delivery_cost')
            ->where('offers.is_active', 1)
            ->first();

        if ( empty($offer) || is_null($offer) )
            return null;

        return [
                'offer_id' => $offer->id,
                'offer_expired_at' => $offer->end_time,
                'before_delivery_cost' => $offer->before_delivery_cost,
                'after_delivery_cost'  => $offer->after_delivery_cost,
            ];
    }
    public static function offerProduct($vendor_id, $product_id)
    {
        $offer = OfferProduct::join('offers', 'offer_id', '=', 'offers.id')
            ->where('offers.end_time', '>=', \Carbon\Carbon::today())
            ->where('offers.vendor_id', $vendor_id)
            ->where('product_id', $product_id)
            ->where('offers.is_active', 1)
            ->first();
        
        if ( empty($offer) || is_null($offer) )
            return null;
        
        $productOffer = [
            'offer_id' => $offer->id,
            'offer_expired_at' => $offer->end_time,
        ];
        switch ($offer->offer_general_type) 
        {
            case 'products_discount':
                $productOffer['offer_type'] = $offer->offer_general_type;
                $productOffer['offer_new_price'] = $offer->offer_new_price;
            break;
            
            case 'buy_get':
                $productOffer['offer_type'] = $offer->offer_general_type;
                $productOffer['offer_buy_count'] = $offer->buy_count;
                $productOffer['offer_get_count'] = $offer->get_count;
                $productOffer['offer_gift_products'] = self::handlerProductsGift($offer->products_gift);
            break;
        }

        return $productOffer;
    }


    private static function handlerProductsGift($products)
    {
        $products = json_decode($products, true);
        if ( empty($products) or !is_array($products) )
            return null;

        $dataProducts = [];
        foreach($products as $key => $product_id)
        {
            $product = Product::where('product_id', $product_id)->where('status', 1)->first();
            $dataProducts[$key]['product_id'] = $product->product_id;
            $dataProducts[$key]['product_name'] = $product->name;
            $dataProducts[$key]['product_image'] = $product->image;
        }
        return $dataProducts;
    }
}