<?php

namespace App\Http\Controllers\Api\Vendor;

use App\Http\Controllers\API\APIVendorAuthController;
use App\Http\Controllers\API\ControllersService;
use App\Http\Controllers\API\Vendor\BasketController;
use App\Http\Controllers\API\Vendor\OffersService;
use App\Http\Controllers\Api\Vendor\Repository\CouponService;
use App\Models\BasketOrdersMain;
use App\Models\CustomersAddresses;
use App\Models\OfferProduct;
use App\Models\Order;
use App\Models\OrderPool;
use App\Models\OrderPoolAddons;
use App\Models\OrderStatusHistory;
use App\Models\Product;
// use App\Models\Product;
// use App\Models\ProductAddon;
// use App\Models\ProductAddonsCategories;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;

class OrderHandlerController extends APIVendorAuthController
{
    public function checkout(Request $request)
    {
        $receive_type = (isset($request->receive_type) && in_array($request->receive_type, ['delivery', 'pickup'])) ? $request->receive_type : 'pickup';


        // check if not found any order in basket
        $orderBasket = BasketOrdersMain::where('rest_id', $this->vendor_id)->where('user_id', auth()->user()->member_id)->where('is_done', 0)->first();
        
        
        if ( empty($orderBasket) || is_null($orderBasket) )
            return ControllersService::generateNewResponse(false, 200, 'BASKET_IS_EMPTY', null);


        // check if not found any products in this basket
        $basketProducts = $orderBasket->basketProducts;
        if ( empty($basketProducts) || is_null($basketProducts) )
            return ControllersService::generateNewResponse(false, 200, 'BASKET_IS_EMPTY', null);

        $resonseData = [];
        
        switch ($this->getVendor()->payment_method)
        {
            case 1:
                $resonseData['payment_type'][0]['key']    = __('cash');
                $resonseData['payment_type'][0]['value']  = 'cash';
            break;
            case 2:
                $resonseData['payment_type'][0]['key']    = __('visa');
                $resonseData['payment_type'][0]['value']  = 'visa';
            break;
            case 3:
                $resonseData['payment_type'][0]['key']    = __('cash');
                $resonseData['payment_type'][0]['value']  = 'cash';
                $resonseData['payment_type'][1]['key']    = __('visa');
                $resonseData['payment_type'][1]['value']  = 'visa';
            break;
            default:
                $resonseData['payment_type'][0]['key']    = __('cash');
                $resonseData['payment_type'][0]['value']  = 'cash';
            break;
        }



        // get member info name and phone
        $resonseData['client_info']['name']  = trim(auth()->user()->fname .' ' . auth()->user()->lname); 
        $resonseData['client_info']['phone'] = auth()->user()->phone;
        $memberAddress = CustomersAddresses::where('member_id', auth()->user()->member_id)->where('vendor_id', $this->vendor_id)->get();
        $resonseData['client_info']['address'] = count($memberAddress) == 0 ? null : $memberAddress;
        

        $products    = (new BasketController)->basketProductsHandler($basketProducts);          
        $basketPrice = $products['products_price'];
        $resonseData['order_info'] = $products['products'];

        $resonseData['checkout_info']['currency']  = $this->currency_code;
        $resonseData['checkout_info']['receive_type']  = $receive_type;
        $resonseData['checkout_info']['sub_price'] = $basketPrice;

       // handler delivery & pickup
       switch ($receive_type) {
           case 'delivery':
            $resonseData['checkout_info']['delivery_cost_offer']   = OffersService::offerVendorDeliveryCost($this->getVendor()->vendor_id);
            if ( $resonseData['checkout_info']['delivery_cost_offer'] != null )
                $resonseData['checkout_info']['delivery_cost']   = $resonseData['checkout_info']['delivery_cost_offer']['after_delivery_cost'];
            else
                $resonseData['checkout_info']['delivery_cost']   = $this->getVendor()->delivery_cost;
            break;
           
           default:
                $resonseData['checkout_info']['delivery_cost'] = 0;
                $resonseData['checkout_info']['delivery_cost_offer'] = null;
            break;
       }

       
        $resonseData['checkout_info']['final_price'] = $resonseData['checkout_info']['delivery_cost'] + $basketPrice;


       return ControllersService::generateNewResponse(true, 200, 'REQUEST_SUCCESS', $resonseData);
    }


    public function newOrder()
    {
        
        $branchID       = request('branchID');
        $paymentType    = request('paymentType'); // (cash or visa)
        $payment_id     = request('payment_id'); // (payment_id)
        $type           = (!empty(request('type'))) ? request('type') : 'delivery'; // (delivery or pickup)
        $couponCode     = request('couponCode');
        $is_qitaf       = (request('is_qitaf') == 'true') ? true : false;
        $tip            = !empty(request('tip')) ? request('tip') : 0;
        $addressID      = request('addressID') ? request('addressID') : 0;
        $is_schedule    = (request('is_schedule') == 'true') ? true : false;
        $schedule_date  = request('schedule_date') ? request('schedule_date') : null;
        $long           = request('long') ? request('long') : 0;
        $lat           = request('lat') ? request('lat') : 0;
        $order_address  = request('order_address');

        // if visa and found PaymentID it's paid
        $is_paid = 0;
        if ( $paymentType == 'visa' && isset($payment_id) )
            $is_paid = 1;

        // check if not found any order in basket
        $orderBasket = BasketOrdersMain::where('rest_id', $this->vendor_id)->where('user_id', auth()->user()->member_id)->where('is_done', 0)->first();
        
        
        if ( empty($orderBasket) || is_null($orderBasket) )
            return ControllersService::generateNewResponse(false, 200, 'BASKET_IS_EMPTY', null);


        // check if not found any products in this basket
        $basketProducts = $orderBasket->basketProducts;
        if ( empty($basketProducts) || is_null($basketProducts) )
            return ControllersService::generateNewResponse(false, 200, 'BASKET_IS_EMPTY', null);

        $newOrder = new Order();
        $newOrder->mbr_id = auth()->user()->member_id;
        $newOrder->vendor_id = $this->vendor_id;
        $newOrder->order_status_id = 6;
        $newOrder->branch_id = $branchID;
        $newOrder->order_date = date("Y-m-d H:i:s");
        $newOrder->order_basket_id = $orderBasket->order_id;
        $newOrder->payment_type = $paymentType;
        $newOrder->address_id = $addressID;
        $newOrder->order_type = $type;
        $newOrder->is_paid = $is_paid;
        $newOrder->order_address = $order_address;
        $newOrder->latitude = $lat;
        $newOrder->longitude = $long;
        $newOrder->save();
        
        
        $productsPrice = 0;
        // add order pool (add products item to order)
        foreach ($basketProducts as $products)
        {
            
            $productsPrice += $products->final_price;
            // add a new pool product item
            $OrderPool = new OrderPool();
            $OrderPool->order_id           = $newOrder->order_id;
            $OrderPool->offer_id           = $products->offer_id;
            $OrderPool->meal_id            = $products->meal_id;
            $OrderPool->meal_size          = $products->meal_size_id;
            $OrderPool->meal_quantity      = $products->meal_quantity;
            $OrderPool->one_meal_price     = $products->one_meal_price;
            $OrderPool->price_with_addons  = $products->final_price;
            $OrderPool->custom_meal_addons = $products->custom_addons;
            $OrderPool->save();
            
           // get all addons for this order
           if ( ! empty($products->basketAddons) )
           {
               foreach ($products->basketAddons as $addon)
               {
                    $OrderPoolAddons = new OrderPoolAddons();
                    $OrderPoolAddons->order_id    = $newOrder->order_id;
                    $OrderPoolAddons->pool_id     = $OrderPool->order_pool_id;
                    $OrderPoolAddons->addon_id    = $addon->addon_id;
                    $OrderPoolAddons->addon_price = $addon->addon_price;
                    // add a new pool product item
                    $OrderPoolAddons->save();
               }
           }
        }
        
        

        // start coupon handler
        ///////////////////////////////////////////
        $beforeDiscount      = $productsPrice;
        $coupon_id           = 0;
        $discount            = 0;
        $vendorDeliveryPrice = 0;
        $deliveryOfferID     = 0;
        $orderFinalPrice     = 0;

        if ($type == 'delivery')
        {
            $vendorDeliveryPrice = $this->deliveryCost;
            $deliveryOfferID     = $this->deliveryOfferID;
        }

        if (!empty($couponCode))
        {
            
            
            $options = [
                'couponCode'    => $couponCode,
                'totalPrice'    => $productsPrice,
                'viaQitaf'      => $is_qitaf,
                'request'       => true,
                'delivery_cost' => $vendorDeliveryPrice,
                'tip'           => $tip,
                'typeReceive'   => $type,
                'order_id'      => $newOrder->order_id,
            ];

            $CouponService = (new CouponService($options))->check();

            if ( $CouponService['statusCoupon'] === true &&  $CouponService['statusCode'] == 200)
            {
                $beforeDiscount  = $CouponService['data']['priceBeforeDiscount'];
                $coupon_id       = $CouponService['data']['couponId'];
                $discount        = $CouponService['data']['couponDiscountAmount'];
                $orderFinalPrice = $CouponService['data']['finalPrice'];
            }
        }
        
        if ( empty($couponCode) OR $CouponService['statusCode'] != 200 )
        {
            $productsPrice  = $productsPrice + $tip;
            // start price handler
            switch ($type) 
            {
                case 'pickup':
                    $orderFinalPrice = $productsPrice;
                break;
                default:
                    $orderFinalPrice = $productsPrice + $vendorDeliveryPrice;
                break;
            }
            $orderFinalPrice = number_format($orderFinalPrice, 2, '.', '');
        }
        
        // create unique order id (invoice  id)
        $invoice_num = 'RF-' . date('y') . str_pad($newOrder->order_id, 3, '0', STR_PAD_LEFT);

        // update Order order
        $newOrder->coupon_id              = $coupon_id;
        $newOrder->total                  = $orderFinalPrice;
        $newOrder->discount               = $discount;
        $newOrder->total_without_discount = $beforeDiscount;
        $newOrder->tip                    = $tip;
        $newOrder->delivery_cost          = $vendorDeliveryPrice;
        $newOrder->order_number           = $invoice_num;
        $newOrder->offer_id               = $deliveryOfferID;
        $newOrder->save();


        $orderStatusNum = 6; // order is sent
        if ( $this->vendor_status == 'closed' && $is_schedule == true && !empty($schedule_date) )
        {
            $newOrder->order_date = $schedule_date;
            $newOrder->is_schedule = 1;
            $newOrder->schedule_order_date = $schedule_date;
            $newOrder->order_status_id = 9; // order is_schedule
            $newOrder->save();
            
            $orderStatusNum = 9; // order is_schedule
        }
        
        // add order_status_history
        $OrderStatusHistory = new OrderStatusHistory();
        $OrderStatusHistory->status_id = $orderStatusNum; 
        $OrderStatusHistory->order_id  = $newOrder->order_id;
        $OrderStatusHistory->save();


    
        // hide from basket
        $orderBasket->is_done = 1;
        $orderBasket->save();

        // send notification to branch's supervisor via pusher
        // $optionsData = [
        //     'message'       => 'new Order',
        //     'branch_id'     => $orderAddItem['branch_id'],
        //     'order_id'      => $newOrder->order_id,
        //     'order_number'  => $dataUpdate['order_number'],
        //     'total'         => $dataUpdate['total'],
        //     'client_name'   => $orderAddItem['client_name'],
        //     'client_phone'  => $orderAddItem['client_phone'],
        //     'date'          => $orderAddItem['order_date']
        // ];
        // $this->notificationsNewOrder($optionsData);
        // // end of send notification to branch's supervisor
        

        $user_lat = $lat;
        $user_lng = $long;

        $location = \DB::select("SELECT branch_id,  latitude, longitude, 111.045 * DEGREES(ACOS(COS(RADIANS($user_lat))
                            * COS(RADIANS(latitude))
                            * COS(RADIANS(longitude) - RADIANS($user_lng))
                            + SIN(RADIANS($user_lat))
                            * SIN(RADIANS(latitude))))
                            AS distance_in_km
                            FROM vendor_branches
                            WHERE branch_id = $branchID
                            ORDER BY distance_in_km ASC
                            ");
      
        // return with success - price before discount - price after discount - order id - coupon object
        $data = [
            'order_id'              => $newOrder->order_id, 
            'price_before_discount' => $beforeDiscount, 
            'price_after_discount'  => $orderFinalPrice,
            'distance_in_km'  => $location
        ];
        // $location = [
        //     'latitude'   => $location->latitude,
        //     'longitude' => $location->longitude,
        //     'distance_in_km'  => $location->distance_in_km,
        // ];
        return ControllersService::generateNewResponse(true, 200, 'ORDER_ADDED_SUCCESS', $data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */

    public function cancelOrder(Request $request)
    {
        
        $roles = [
            'order_id'      => 'required|numeric',
            'cancel_reason' => 'required|string',
        ];

        $validator = Validator::make($request->all(), $roles);
        if ($validator->fails())
            return ControllersService::generateNewResponse(false, 400, 'NO_AUTH_CODE', $validator->getMessageBag()->first());

        $order = Order::where('order_id', $request->order_id)->first();

        if ( $order->order_status_id == 7 )
            return ControllersService::generateNewResponse(false, 400, 'CANCELD_ORDER', null);

        if ( $order->order_status_id != 6 )
            return ControllersService::generateNewResponse(false, 400, 'CANCEL_ORDER_ERROR_STATUS', null);
        
        $maxTimeAllowed = \Carbon\Carbon::now()->subMinutes(30)->toDateTimeString();
        if ( $order->order_date >= $maxTimeAllowed )
        {
            $order->order_status_id = 7;
            $order->save();

            $OrderStatusHistory = new OrderStatusHistory();
            $OrderStatusHistory->order_id = $request->order_id;
            $OrderStatusHistory->status_id = 7;
            $OrderStatusHistory->cancel_reason_id = 1;
            $OrderStatusHistory->created_by = auth()->user()->member_id;
            $OrderStatusHistory->status_comment = $request->cancel_reason;
            $OrderStatusHistory->save();
            
            return ControllersService::generateNewResponse(false, 400, 'CANCEL_ORDER_SUCCESS', null);
        }
        

        return ControllersService::generateNewResponse(false, 400, 'CANCEL_ORDER_ERROR_TIME', null);
    }


    public function myOrders()
    {
        $orders = Order::where('mbr_id', auth()->user()->member_id)->where('vendor_id', $this->vendor_id)->get();
        if ( count($orders) == 0 )
            return ControllersService::generateNewResponse(true, 404, 'ORDERS_EMPTY', null);

            
        $responseData = [];
        foreach ($orders as $key => $order)
            $responseData[$key] = $this->getFullOrderInfo($order);
        
        return ControllersService::generateNewResponse(true, 200, 'REQUEST_SUCCESS', $responseData);
    }

    public function orderInfo(Request $request)
    {
        $orderID = (int) $request->order_id;
        if ( $orderID == 0 )
            return ControllersService::generateNewResponse(true, 404, 'NOT_FOUND', null);

        $order = Order::find($orderID);

        if ( empty($order))
            return ControllersService::generateNewResponse(true, 404, 'NOT_FOUND', null);

        $responseData = $this->getFullOrderInfo($order);        
        return ControllersService::generateNewResponse(true, 200, 'REQUEST_SUCCESS', $responseData);
    }
    
    public function orderTrack(Request $request)
    {
        $orderID = (int) $request->order_id;
        if ( $orderID == 0 )
            return ControllersService::generateNewResponse(true, 404, 'NOT_FOUND', null);
            
        $order = Order::find($orderID);

        if ( empty($order))
            return ControllersService::generateNewResponse(true, 404, 'NOT_FOUND', null);

        $responseData = $this->getFullOrderInfo($order);        
        return ControllersService::generateNewResponse(true, 200, 'REQUEST_SUCCESS', $responseData);
    }
    
    
    private function getFullOrderInfo(Order $order)
    {
        
        $responseData = [];
        $responseData['order_id'] = $order->order_id;
        $responseData['order_number'] = $order->order_number;
        $responseData['order_date'] = $order->order_date;
        
        // handler branch info
        $responseData['branch']    = null;
        if ( $order->branch_id != 0 && $order->branch_id != null )
        {
            $responseData['branch']['branch_id']    = $order->branch->branch_id;
            $responseData['branch']['branch_name']  = $order->branch->name;
            $responseData['branch']['branch_lat']   = $order->branch->longitude;
            $responseData['branch']['branch_long']  = $order->branch->latitude;
        }
        
        // handler order status
        $responseData['is_schedule']   = $order->status->order_status_id == 9 ? true : false; // object of status
        if ( $responseData['is_schedule'] == true )
            $responseData['is_schedule_date'] = $order->schedule_order_date;

        $responseData['order_status']['id']   = $order->status->order_status_id; // object of status
        $responseData['order_status']['name'] = $order->status->name; // object of status
        $responseData['order_status']['desc'] = $order->status->desc; // object of status
        
        $responseData['delivery_cost']  = $order->delivery_cost;
        $responseData['delivery_offer'] = $order->deliverOffer;

        // handler prices
        $responseData['discount']               = $order->discount;
        $responseData['total_without_discount'] = $order->total_without_discount;
        $responseData['total']                  = $order->total;
        $responseData['payment_type']           = $order->payment_type;
        $responseData['tip']                    = $order->tip;
        $responseData['order_type']             = $order->order_type;
        $responseData['is_paid']                = $order->is_paid == 0 ? false : true;


        $products = $order->order_pools;
        foreach( $products as $i => $product)
        {
            $offer = OfferProduct::join('offers', 'offer_id', '=', 'offers.id')
            ->where('offers.id', $product->offer_id)
            ->where('offers.is_active', 1)
            ->first();
            
            $pureProduct = Product::where('product_id', $product->meal_id)->first();
            $responseData['products'][$i]['order_pool_id']      = $product->order_pool_id;
            $responseData['products'][$i]['offer']              = $offer;
            $responseData['products'][$i]['product_id']         = $product->meal_id;
            $responseData['products'][$i]['quantity']           = $product->meal_quantity;
            $responseData['products'][$i]['one_product_price']  = $product->one_meal_price;
            $responseData['products'][$i]['price_with_addons']  = $product->price_with_addons;
            $responseData['products'][$i]['custom_meal_addons'] = $product->custom_meal_addons;
            $responseData['products'][$i]['product_name']       = $pureProduct->name;
            $responseData['products'][$i]['product_desc']       = $pureProduct->desc;
            $responseData['products'][$i]['image']              = $pureProduct->image;
            // $responseData['products'][$i]['meal_addons']        = $product->;
        }

        // $responseData['order_address'] = $order->order_address; // object of address
        // $responseData['coupon_id'] = $order;
        // $responseData['qitaf_coupon_id'] = $order;
        // $responseData['coupon'] = $order; // object
        return $responseData;
    }





}
