<?php

namespace App\Http\Controllers\Api\Vendor\Payments;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Controllers\API\APIVendorAuthController;
use App\Http\Controllers\API\ControllersService;
use App\Http\Controllers\Api\Vendor\Repository\CouponService;
use App\Models\BasketOrdersMain;
use App\Models\PaymentMethodVendors;
use App\Models\Product;

class MyFatoorahController extends APIVendorAuthController
{
    public function __construct()
    {
        parent::__construct();
    }
    public function getAuth()
    {
        // 2 is myfatoorah
        $PaymentMethodVendors = PaymentMethodVendors::where('vendor_id', $this->vendor_id)->where('payment_method_id', 2)->where('is_active', 1)->first();
        if ( is_null($PaymentMethodVendors) )
            return ControllersService::generateNewResponse(false, 404, 'MYFATOORAH_NOT_FOUND', null);

        return ControllersService::generateNewResponse(true, 200, 'REQUEST_SUCCESS', [ 'providor' => 'myfatoorah', 'base_url' => $PaymentMethodVendors->mf_base_url, 'token' => $PaymentMethodVendors->token]);
    }


    public function handlerPaymentOrder(Request $request)
    {
        $PaymentMethodVendors = PaymentMethodVendors::where('vendor_id', $this->vendor_id)->where('payment_method_id', 2)->where('is_active', 1)->first();
        if ( is_null($PaymentMethodVendors) )
            return ControllersService::generateNewResponse(false, 404, 'MYFATOORAH_NOT_FOUND', null);


        $couponCode     = $request->couponCode;
        $is_qitaf       = (isset($request->is_qitaf) && $request->is_qitaf == 'true') ? true : false;
        $tip            = !empty($request->tip) ? $request->tip : 0;
        $type           = (isset($request->type) && !empty($request->type)) ? $request->type : 'delivery'; // (delivery or pickup)
        $member         = auth()->user();

        // check if not found any order in basket
        $orderBasket = BasketOrdersMain::where('rest_id', $this->vendor_id)->where('user_id', auth()->user()->member_id)->where('is_done', 0)->first();
        
        
        if ( empty($orderBasket) || is_null($orderBasket) )
            return ControllersService::generateNewResponse(false, 200, 'BASKET_IS_EMPTY', null);


        // check if not found any products in this basket
        $basketProducts = $orderBasket->basketProducts;
        if ( empty($basketProducts) || is_null($basketProducts) )
            return ControllersService::generateNewResponse(false, 200, 'BASKET_IS_EMPTY', null);
          
            

        $fullPrice = 0;
        $products  = [];
        foreach ($basketProducts as $index => $basketItem)
        {
            $fullPrice += $basketItem->final_price;

            $product = Product::find($basketItem->meal_id);

            $products[$index]['ItemName']  = $product->name;
            $products[$index]['Quantity']  = $basketItem->meal_quantity;
            $products[$index]['UnitPrice'] = $basketItem->one_meal_price;
        }
        
       $delivery_cost = 0;
        if ( $type == 'delivery' )
        {
          $delivery_cost = $this->deliveryCost;
          $products[count($products)] =
          [
            'ItemName' => 'delivery',
            'Quantity' => '1',
            'UnitPrice' => $delivery_cost
          ];
        }

      if ( $tip != 0 )
      {
        $products[count($products)] =
        [
          'ItemName' => 'tip',
          'Quantity' => '1',
          'UnitPrice' => $tip
        ];
      }
      
      // final price without any discount
      $FinalPrice = number_format($fullPrice, 2, '.', '');
      

      // check coupon
      $coupon = null;
      if ( ! empty($couponCode) )
      {
        $options = [
            'couponCode'    => $couponCode,
            'totalPrice'    => $FinalPrice,
            'viaQitaf'      => $is_qitaf,
            'request'       => false,
            'delivery_cost' => $delivery_cost,
            'tip'           => $tip,
            'typeReceive'   => $type,
            'order_id'      => '',
        ];

        $coupon = (new CouponService($options))->check();
        
        if ($coupon['statusCoupon'] == true &&  $coupon['statusCode'] == 200)
        {
           $FinalPrice = $coupon['data']['finalPrice'];
           $products[count($products)] =
           [
             'ItemName' => 'amount before dicount',
             'Quantity' => '1',
             'UnitPrice' => $coupon['data']['priceBeforeDiscount'],
           ];
        }
      }// end of check coupon;

      if ( empty($couponCode) OR  $coupon['statusCoupon'] == false)
      {
        $FinalPrice = $FinalPrice + $tip + $delivery_cost;
      }

      $countryCode = $this->getCountry()->country_code;

      $phonePure  = preg_replace("/^\+?{$countryCode}/", '',$member->phone);
      $dataApiReturn = json_encode([
              'order_id' => '',
              'couponCode' => $couponCode,
              'is_qitaf' => $is_qitaf,
              'tip' => $tip,
              'type' => $type,
            ]);
      // return with success - price before discount - price after discount - order id - coupon object
      $data = [
      'NotificationOption' => 'ALL',
      'CustomerName'       => $member->fname . ' ' . $member->lname,
      'DisplayCurrencyIso' => $this->currency_code,
      'MobileCountryCode'  => $countryCode,
      'CustomerMobile'     => $phonePure,
      'CustomerEmail'      => 'customer@yalago.com',
      'InvoiceValue'       => $FinalPrice,
      'Language'           => app()->getLocale() == 'en' ? 'en' : 'ar',
      'CustomerReference'  => $member->member_id,
      'UserDefinedField'   => $dataApiReturn,
      'ApiCustomFileds'    => $dataApiReturn,
      'InvoiceItems'       => $products,
      'API_Token'          => $PaymentMethodVendors->token,
      'API_URL'            => $PaymentMethodVendors->mf_base_url,
      'coupon' => $coupon];
      
       return ControllersService::generateNewResponse(true, 200, 'REQUEST_SUCCESS', $data);

    }





}
