<?php
namespace App\Http\Controllers\API\Vendor;

use App\Http\Controllers\API\APIVendorAuthController;
use App\Http\Controllers\API\ControllersService;
use App\Http\Controllers\API\Vendor\OffersService;
use App\Models\Product;
use App\Models\ProductAddon;
use App\Models\ProductAddonsCategories;
use App\Models\ProductImages;
use App\Models\ProductRate;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\ProductCategory;

class ProductsController extends APIVendorAuthController
{
  
  // reqest to show all products by category id 
  public function productInfo()
  {
    $product_id = (int) request('product_id');
    
    if ( $product_id == 0 )
      return ControllersService::generateNewResponse(false, 400, 'NOT_FOUND');

    $resonseData = [];
    
    $resonseData['product_info'] = null;
    $product = Product::where('vendor_id', $this->vendor_id)->where('product_id', $product_id)->where('status', 1)->first();

    if ( is_null($product) )
      return ControllersService::generateNewResponse(false, 400, 'NOT_FOUND');


    $resonseData['product_info']['product_id']     = $product->product_id;
    $resonseData['product_info']['product_name']   = $product->name;
    $resonseData['product_info']['product_desc']   = $product->desc;
    $resonseData['product_info']['image_preview']  = url($product->meal_image);
    $resonseData['product_info']['images']         = $product->productImages->map(function ($image){ 
       return ['id' => $image->image_id, 'image_url' => url($image->image_url)];  
    });
    $resonseData['product_info']['price_currency'] = $this->currency_code;

    // $resonseData['product_info']['price']          = $product->price;
    // $resonseData['product_info']['product_offer']  = OffersService::offerProduct($product->vendor_id,$product->product_id);

    $resonseData['product_info']['product_offer']  = OffersService::offerProduct($this->vendor_id,$product->product_id);
    if ( $resonseData['product_info']['product_offer'] != null && $resonseData['product_info']['product_offer']['offer_type'] == 'products_discount' )
    {
      $resonseData['product_info']['product_price_before'] = $product->price;
      $resonseData['product_info']['price']  = $resonseData['product_info']['product_offer']['offer_new_price'];
    }else{
      $resonseData['product_info']['product_price_before'] = null;
      $resonseData['product_info']['price'] = $product->price;
    }
    
    // get all this addons with category
    $fullAddons = null;
    $addonsCategories = ProductAddonsCategories::where('rest_id', $this->vendor_id)->get();

    if ( ! is_null($addonsCategories) )
    {
      
      $key = 0;
      foreach ($addonsCategories as $category) 
      {
        $addons =  ProductAddon::where('addon_category_id', $category->cat_id)->where('meal_id', $product->product_id)->where('addon_is_active', 1)->get();
                
        if ( count($addons) == 0 )
          continue;
          
        $fullAddons['addon_category'][$key]['cat_id']          =  $category->cat_id;
        $fullAddons['addon_category'][$key]['cat_name']        =  $category->name;
        $fullAddons['addon_category'][$key]['cat_choose_type'] =  $category->choose_type;

        $keyAddon = 0;
        foreach ($addons as $addon) 
        {
          $fullAddons['addon_category'][$key]['addons'][$keyAddon]['addon_id']    = $addon->addon_id;
          $fullAddons['addon_category'][$key]['addons'][$keyAddon]['addon_name']  = $addon->name;
          $fullAddons['addon_category'][$key]['addons'][$keyAddon]['addon_price'] = $addon->addon_price;
          $fullAddons['addon_category'][$key]['addons'][$keyAddon]['addon_price_currency'] = $this->currency_code;
          $fullAddons['addon_category'][$key]['addons'][$keyAddon]['addon_is_free'] = $addon->addon_price == 0 ? true : false;
          
          $keyAddon++;
        }

        $key++;
      }
    }
    $resonseData['product_info']['addons'] = $fullAddons;
    // end of all addons handler with categories and addons

    return ControllersService::generateNewResponse(true, 200, 'REQUEST_SUCCESS', $resonseData);
  }


  public function makeProductRate(Request $request)
  {
    $roles = [
      'product_id' => 'required|numeric',
      'rate_value' => 'required|numeric',
      'rate_notice' => 'sometimes|required|string',
      
  ];
  $validator = Validator::make($request->all(), $roles);

  // if error in validation
  if ($validator->fails())
      return ControllersService::generateNewResponse(false, 400, 'NO_AUTH_CODE',$validator->getMessageBag()->first());



      $ProductRate = new ProductRate();
      $ProductRate->meal_id = request('product_id');
      $ProductRate->rating_value = request('rate_value');
      $ProductRate->member_id = auth()->user()->member_id;
      $ProductRate->rate_notice = request('rate_notice');
      $ProductRate->save();


      $avgStar = ProductRate::where('meal_id', request('product_id'))->avg('rating_value');
      $avgStar = number_format($avgStar, 2);
      return ControllersService::generateNewResponse(true, 200, 'REQUEST_SUCCESS', ['product_new_rate' => $avgStar]);
  }
  public function productCategory()
  {
    $product = ProductCategory::where('vendor_id',$this->vendor_id)->with('Productcategory')->get();
    return response()->json([
      'status' => true,
      'message' => 'Success',
      'data' => $product
    ]);
  }
  
}
