<?php

namespace App\Http\Controllers\Api\Vendor\Repository;

use App\coupon_code;
use App\Http\Controllers\API\APIVendorAuthController;
use App\Http\Controllers\API\ControllersService;
use App\Models\Coupon;
use App\Models\CouponHistory;
use App\Models\QitafCouponsHistory;

class CouponService extends APIVendorAuthController
{
    protected $coupon_code,
              $total_price,
              $is_qitaf, // false or true
              $request,
              $order_type, // pickup or delivery
              $tip,
              $delivery_cost,
              $type_receive,
              $order_id;

    public function __construct(array $options)
    {
        parent::__construct();

        $this->coupon_code   = $options['couponCode'] ?? null;
        $this->total_price   = $options['totalPrice'] ?? null;
        $this->is_qitaf      = $options['viaQitaf'] ?? null;
        $this->request       = $options['request'] ?? null;
        $this->delivery_cost = $options['delivery_cost'] ?? null;
        $this->tip           = $options['tip'] ?? null;
        $this->order_id      = $options['order_id'] ?? null;
        $this->type_receive  = $options['type'] ?? 'delivery';

        if ( $this->type_receive == 'pickup' )
            $this->delivery_cost = 0;

        return $this;
    }

    public function check()
    {
        if ( $this->is_qitaf === true )
            return $this->Qitaf();

        return $this->system();
    }

    private function qitaf(){


        $curl       = curl_init();
        $postFields = [
        'apiName' => 'couponDetails',
        'userKey' => $this->getQitafAuthToken()->user_key,
        'language' => 'en',
        'param' => [
               'coupon'      => $this->coupon_code,
               'totalAmount' => $this->total_price
            ]
        ];

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://coponey.com/api/ecommerce/',
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => json_encode($postFields),
            CURLOPT_HTTPHEADER => array("Authorization: " . $this->getQitafAuthToken()->token ,"Content-Type: application/json"),
        ));

        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($curl);
        curl_close($curl);

        $response = json_decode($response, true);

        if ( isset($response['error']) )
            return ['statusCoupon' => false, 'statusMsg' => $response['error']['message'], 'statusCode' => 400, 'data' => []];


        if ( $response['response']['status'] == 114 )
            return ['statusCoupon' => false, 'statusMsg' => 'COUPON_NOT_FOUND', 'statusCode' => 404, 'data' => []];



        if ( $response['response']['status'] == 112 )
            return ['statusCoupon' => false, 'statusMsg' => 'QITAF_AUTH_ERROR', 'statusCode' => 400, 'data' => []];


        if ( $response['response']['status'] != 200 )
            return ['statusCoupon' => false, 'statusMsg' => 'COUPON_IS_EXPIRED', 'statusCode' => 400, 'data' => []];



        // handler price with coupon
         // discountType  percent , amount

         $priceBeforeDiscount = $this->total_price;

         $discount_type = 'amount';
         switch ($response['response']['result']['discountType'])
         {
           case 'percent': // handler percentage coupon
              $discountAmount  = ($this->total_price * $response['response']['result']['discountValue']);
              $discountAmount  = ($discountAmount / 100);
              $this->total_price   = ($this->total_price - $discountAmount);
              $discount_type = 'percent';
             break;

           default : // handler amount coupon
              $this->total_price = ( $this->total_price - $response['response']['result']['discountValue'] );
              $discountAmount    = $response['response']['result']['discountValue'];
             break;
         }


        $orderFinalPrice = ($this->total_price + $this->delivery_cost + $this->tip);

        if ( $this->request )
        {
            // store into coupon history
            $QitafCouponsHistory = new QitafCouponsHistory();
            $QitafCouponsHistory->order_id = $this->order_id;
            $QitafCouponsHistory->member_id = auth()->user()->member_id;
            $QitafCouponsHistory->coupon_code = $this->coupon_code;
            $QitafCouponsHistory->discount_value = $discountAmount;
            $QitafCouponsHistory->discount_type = $discount_type;
            $QitafCouponsHistory->after_discount = $this->total_price;
            $QitafCouponsHistory->total = $orderFinalPrice;
            $QitafCouponsHistory->save();
        } // end of request this copoun


        return [
        'statusCoupon' => true,
        'statusCode' => 200,
        'statusMsg' => 'COUPON_SUCCESS',
        'data' => [
                'couponCode' => $this->coupon_code,
                'couponId' => 0,
                'title' => $response['response']['result']['title'],
                'priceBeforeDiscount' => number_format($priceBeforeDiscount, 2),
                'couponDiscountAmount' => number_format($discountAmount, 2),
                'finalPrice' => number_format( $orderFinalPrice , 2),
            ]
        ];
    }
    private function system(){

        $coupon = coupon_code::where('coupon_codes.copupn_uuid', $this->coupon_code)
                ->join('coupon_vendors', 'coupon_codes.coupon_id', '=', 'coupon_vendors.coupon_id')
                ->join('coupons', 'coupon_codes.coupon_id', '=', 'coupons.coupon_id')
                ->where('coupon_vendors.vendor_id', $this->vendor_id)
                ->whereDate('coupons.start_time', '<=', \Carbon\Carbon::now())
                ->whereDate('coupons.end_time', '>=', \Carbon\Carbon::now())
                ->first();

        if ( is_null($coupon) )
            return ['statusCoupon' => false, 'statusMsg' => 'COUPON_NOT_FOUND', 'statusCode' => 404, 'data' => []];

        // this is coupon is used
        if ( $coupon->orders_limits != 0 && $coupon->usage_expire >= $coupon->orders_limits )
            return ['statusCoupon' => false, 'statusMsg' => 'COUPON_IS_EXPIRED', 'statusCode' => 402, 'data' => []];


         // handler price with coupon
         // 1 Percentage ,2 Amount ,3 Free Delivery

         $priceBeforeDiscount = $this->total_price;
         $discountValueOrigin = $coupon->discount;
         switch ($coupon->coupon_type)
         {
           case '1': // handler percentage coupon
              $coupon->discount  = ($this->total_price * $coupon->discount);
              $coupon->discount  = ($coupon->discount / 100);
              $this->total_price = ($this->total_price - $coupon->discount);
              $discountValueOrigin = 'Discount Percentage ' . $discountValueOrigin . '%';
             break;

           default : // handler amount coupon
              $discountValueOrigin = 'Discount Amount ' . number_format($discountValueOrigin, 2);
              $this->total_price = ( $this->total_price - $coupon->discount );
             break;
         }


         if ( $this->request )
         {
            // update this usage_expire increment one
            Coupon::where('coupon_id', $coupon->coupon_id)->increment('usage_expire');

            // store into coupon history
            $CouponHistory = new CouponHistory();
            $CouponHistory->coupon_id = $coupon->coupon_id;
            $CouponHistory->member_id = auth()->user()->member_id;
            $CouponHistory->order_id  = $this->order_id;
            $CouponHistory->save();

         } // end of request this copoun


         return [
            'statusCoupon' => true,
            'statusCode' => 200,
            'statusMsg' => 'COUPON_SUCCESS',
            'data' => [
                'couponCode' => $this->coupon_code,
                'couponId' => $coupon->coupon_id,
                'title' => $discountValueOrigin,
                'priceBeforeDiscount' => number_format($priceBeforeDiscount, 2),
                'couponDiscountAmount' => number_format($coupon->discount, 2),
                'finalPrice' => number_format( ($this->total_price + $this->delivery_cost + $this->tip) , 2),
            ]
          ];
    }
}
