<?php

namespace App\Http\Controllers\API\Vendor;

use App\Http\Controllers\API\APIVendorAuthController;
use App\Models\Vendor;
use App\Sms_method_vendor;
use GuzzleHttp\Client;

class SmsController extends APIVendorAuthController
{
    public static $ACTIVATION_CODE = 1;
    public static $PASSWORD_RESET_CODE = 2;
    public static $LOGIN_CODE = 3;
    public static $BRANCH_ACCEPTED = 4;
    public static $MOBILE_NUMBER_CHANGED = 5;
    public static $CUSTOMER_WELCOME_MESSAGE = 6;
    public static $NEW_ORDER_MESSAGE = 7;
    public static $GENERATE_PASSWORD = 8;

    public static function sendSmsCodeMessage($mobile_number, $messageType, $userType = "user", $email = "")
    {
        $generatedData = "";
        if ($messageType == self::$GENERATE_PASSWORD) {
            $generatedData = self::generateRandomPassword();
        } else {
            $generatedData = self::generateRandomNumber();
        }
        $MESSAGE = self::generateMessage($messageType, $userType, $email, $generatedData);

        $resp = self::sendSmsMessage($mobile_number, $MESSAGE);

        if (substr($resp, 0, 1) == 0) {
            return $generatedData;
        } else {
            return false;
        }
    }

    public static function sendSmsMessages($mobile_number, $messageType)
    {
        $MESSAGE = self::generateMessage($messageType);
        $resp = self::sendSmsMessage($mobile_number, $MESSAGE);
        if (substr($resp, 0, 1) == 0) {
            return true;
        } else {
            return false;
        }
    }

    private static function generateRandomNumber()
    {
        // $number = mt_rand(1000, 9999);
        $number = '1234';
        return "" . $number;
    }

    private static function generateRandomPassword()
    {
        $password = str_random(6);
        return "" . $password;
    }

    /**
     * @param $messageType
     * @param $userType
     * @param $email
     * @param $code
     * @return string
     */
    public static function
    generateMessage($messageType, $userType = 'Customer', $email = '', $code = ''): string
    {
        $MESSAGE = "";
        switch ($messageType) {
            case self::$LOGIN_CODE:
                $MESSAGE = "أهلا و سهلا بك في تطبيق الولاء, رمز تسجيل الدخول الخاص بك هو: " . $code;
                break;

            case self::$GENERATE_PASSWORD:
                $MESSAGE = "أهلا و سهلا بك في تطبيق الولاء, كلمة المرور الخاصة بحسابك هي: " . $code . "  ترسل هذه الرسالة لمرة واحدة و سيتم اعتماد كلمة المرور, يمكنك تغيرها من خلال التطبيق.";
                break;

            case self::$ACTIVATION_CODE:
                $MESSAGE = "أهلا و سهلا بك في نظام الولاء, رمز تفعيل الحساب الخاص بك هو: " . $code;
                break;

            case self::$PASSWORD_RESET_CODE:
                $MESSAGE = "أهلا و سهلا بك في نظام الولاء, رمز تعديل كلمة المرور الخاصة بك هو: " . $code;
                break;

            case self::$BRANCH_ACCEPTED:
                $MESSAGE = "أهلا و سهلا بك في نظام الولاء, تم قبول طلبكم بإضافة الفرع الجديد الى نظام المتجر الخاص بك." . $code;
                break;

            case self::$MOBILE_NUMBER_CHANGED:
                $MESSAGE = "أهلا و سهلا بك في نظام الولاء, رمز تفعيل رقم الجوال الجديد هو: " . $code;
                break;

            case self::$CUSTOMER_WELCOME_MESSAGE:
                $MESSAGE = "تهانينا, لقد تم تفعيل حسابكم بنجاح, الولاء سعيد بانضمامكم.";
                break;

            case self::$NEW_ORDER_MESSAGE:
                $MESSAGE = "أهلا و سهلا بك في نظام الولاء, رمز تأكيد الطلب الخاص بك هو:  " . $code;
                break;
        }
        return $MESSAGE;
    }

    /**
     * @param $mobile_number
     * @param $message
     * @return mixed
     */
   private static function sendSMSMessage($mobile_number, $message)
    {
        $vendor = Vendor::where('link_name', request()->vendor_uuid)->first();
        $sms_provider = Sms_method_vendor::where('vendor_id', $vendor->vendor_id)->first();
         if (empty($sms_provider) && is_null($sms_provider)) {
            $USER_NAME = "---";
            $PASSWORD = "---";
            $SENDER = "---";
            $MESSAGE = $message;
            $NUMBER = "00970" . $mobile_number;

            // $URL = "http://int.mtcsms.com/sendsms.aspx?username=" . $USER_NAME . "&password=" . $PASSWORD . "&from=" . $SENDER . "&to=" . $NUMBER . "&msg=" . $MESSAGE . "&type=0";

            // $client = new Client();
            // $response = $client->request('GET', $URL);
            // $statusCode = $response->getStatusCode();
            // $content = $response->getBody();
            $content = 'Send Msg Mobile';
            $statusCode = 200;
            return response()->json(['status' => $statusCode, 'content' => $content]);
             }else{
            $url = $sms_provider->url;
            $userAccount = $sms_provider->userName_Acoount;
            $passAccount = $sms_provider->password;
            $sender = $sms_provider->sender;
            $applicationType = "68";
            $MsgID = rand(22, 99);
            $sender = urlencode($sender);
            $domainName = $_SERVER['SERVER_NAME'];
            $stringToPost = "mobile=" . $userAccount . "&password=" . $passAccount . "&numbers=" . $mobile_number . "&sender=" . $sender . "&msg=" . $message . "&timeSend=0&dateSend=0&returnJson=1&applicationType=" . $applicationType . "&msgId=" . $MsgID . "&lang=3";

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_HEADER, 0);
            curl_setopt($ch, CURLOPT_TIMEOUT, 5);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $stringToPost);
            $result = curl_exec($ch);

            $result = (json_decode($result, true));

            if ($result['ResponseStatus'] == 'fail')
            return false;
            else
                return true;      
                }
    

//        return response()->json(['status' => $resp]);
    }



    public static function getSmsBalance(){
        $USER_NAME = "---";
        $PASSWORD = "---";

        $URL = "http://api.mtcsms.com/balance.aspx?username=" . $USER_NAME . "&password=" . $PASSWORD;

        $client = new Client();
        $response = $client->request('GET', $URL);
        $statusCode = $response->getStatusCode();
        $content = $response->getBody();

        $balance = explode('@', $content);

        return "".$balance[1];
    }
}
