<?php

namespace App\Http\Controllers\API\Vendor;

use App\Helpers\Messages;
use App\Http\Controllers\API\ControllersService;
use App\Models\Member;
use App\Models\MobileIdDevice;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;


class UserApiAuthController extends AuthBaseController
{

    //
    //php artisan passport:client --personal
    public function resendActiveCode(Request $request)
    {
        $roles = [
            'phone' => 'required|numeric|digits:12',
            //'password' => 'required|min:6',
        ];
        $validator = Validator::make($request->all(), $roles);

        // if error in validation
        if ($validator->fails())
            return ControllersService::generateValidationErrorMessage($validator->getMessageBag()->first());
        
            
            $user = Member::where("phone", $request->post('phone'))->first();

            if ( empty($user) or is_null($user) )
                return ControllersService::generateNewResponse(false, 404, 'ERROR_CREDENTIALS', null);
            

            // generate an active code and send via sms
            $user->phone_code_valid = SmsController::sendSmsCodeMessage($request->post('phone'), 3);
            $user->save();

            $returnData = [
                'phone' => $request->post('phone'),
                'code_sent' => $user->phone_code_valid,
                'sms_sent_status' => true,
                'member_full_info' => $user,
            ];
            return ControllersService::generateNewResponse(true, 200, 'AUTH_CODE_SENT', $returnData);
    }
    

    public function login(Request $request)
    {
        $roles = [
            'phone' => 'required|numeric|digits:12',
            //'password' => 'required|min:6',
        ];
        $validator = Validator::make($request->all(), $roles);

        // if error in validation
        if ($validator->fails())
            return ControllersService::generateValidationErrorMessage($validator->getMessageBag()->first());
        
            $memberCase = 'login';
            $user = Member::where("phone", $request->post('phone'))->first();

            if ( empty($user) or is_null($user) )
            {
                 // register a new member with phone
                 $user = new Member();
                 $user->phone    = $request->post('phone');
                 $memberCase = 'signup';
            }

            // generate an active code and send via sms
            $user->phone_code_valid = SmsController::sendSmsCodeMessage($request->post('phone'), 3);
            $user->save();

            $returnData = [
                'member_case' => $memberCase,
                'phone' => $request->post('phone'),
                'code_sent' => $user->phone_code_valid,
                'sms_sent_status' => true,
                'member_full_info' => $user,
            ];
            
            return ControllersService::generateNewResponse(true, 200, 'AUTH_CODE_SENT', $returnData);
    }

    /*
    public function register(Request $request)
    {
        $roles = [
            //'email' => 'required|email|unique:users',
            'phone' => 'required|numeric|unique:member|digits:12',
            //'password' => 'required|min:6',
        ];
        $validator = Validator::make($request->all(), $roles);
        if (!$validator->fails()) {
            $user = new Member();
            $user->phone = $request->post('phone');
            $user->phone_code_valid = SmsController::sendSmsCodeMessage($request->get('phone'), 3);
            $isSaved = $user->save();
            if ($isSaved) {
                return ControllersService::generateObjectSuccessResponseSMS($user->phone_code_valid, Messages::getMessage('AUTH_CODE_SENT'), $request->get('phone'));
            }
        } else {
            return ControllersService::generateValidationErrorMessage($validator->getMessageBag()->first());
        }
    }
    */


    public function submitCode(Request $request)
    {
        // ارسال توكن
        $roles = [
            'code' => 'required|numeric|digits:4',
        ];
        $validator = Validator::make($request->all(), $roles);
        if ($validator->fails())
            return ControllersService::generateValidationErrorMessage($validator->getMessageBag()->first());

            
        $user = Member::where("phone", $request->post('phone'))->first();
        if ($request->code == $user->phone_code_valid) 
        {
            $user->is_reg_active = 1;
            $user->save();
            $this->revokePreviousTokens($user->member_id);
            return $this->generateToken($user, 'LOGGED_IN_SUCCESSFULLY');
        } else {
                    return ControllersService::generateNewResponse(false,400,'ERROR_CREDENTIALS', Null);


        }
            
    }

    public function checkCustomerCase(Request $request)
    {
        $roles = [
            'phone' => 'required|numeric|digits:12',
            //'password' => 'required|min:6',
        ];
        $validator = Validator::make($request->all(), $roles);
        if (!$validator->fails())
        {
            $user = Member::where("phone", $request->get('phone'))->first();
            if ($user)
            {
                return ControllersService::generateNewResponse(true, 200, 'REQUEST_SUCCESS', ['case' => 'login']);
            } else {
                return ControllersService::generateNewResponse(true, 200, 'REQUEST_SUCCESS', ['case' => 'signup']);
            }
        } else {
            return ControllersService::generateNewResponse(false, 400, 'NO_AUTH_CODE', $validator->getMessageBag()->first());
        }
    }


    public function info(Request $request)
    {
        return ControllersService::generateNewResponse(true, 200, 'REQUEST_SUCCESS', $this->handlerMemberInfo(auth()->user()));
    }

    public function update(Request $request)
    {
        $roles = [
            'fname'    => 'sometimes|required|string|min:3',
            'lname'    => 'sometimes|required|string|min:3',
            'avatar'   => 'sometimes|required|image',
            'gender'   => 'sometimes|required|string|min:4|max:10',
            'email'    => 'sometimes|required|email|min:3',
            'birthday' => 'nullable|date_format:Y-m-d|before:today',
         ];
        $validator = Validator::make($request->all(), $roles);

        if ( $validator->fails() )
            return ControllersService::generateNewResponse(false, 400, 'USER_UPDATED_FAILED', $validator->getMessageBag()->first());



        // $avatarPath = auth()->user()->avatar;
        // if($request->hasFile('avatar'))
        // {
        //     $file = $request->file('avatar');
        //     $name         = $file->getClientOriginalName();
        //     $pureFileName = pathinfo($name)['filename'];
        //     $pureFileExt  = pathinfo($name)['extension'];
        //     $file_name    = \Str::random(10) .'_'.\Str::slug($pureFileName);
        //     $file_name    = strtolower($file_name) . '.' . $pureFileExt;
        //     $pathFile     = 'uploads/customers/avatars/'. auth()->user()->member_id . '/';
        //     //$file->move($pathFile, $file_name);
        //     $avatarPath   = $pathFile . $file_name;
        //     \Image::make($file->getRealPath())->resize(400, 400, function ($constraint) {
        //         $constraint->aspectRatio();
        //         $constraint->upsize();
        //     })->save($pathFile . '/' . $file_name);


        //     // remove old image
        //     $oldAvatar = auth()->user()->avatar;
        //     if($oldAvatar != 'uploads/members/default.png' && ! empty($oldAvatar))
        //         \File::delete($oldAvatar);
        // }
        // change avatar file
       
        $user = Member::find($request->user('user_api')->member_id);
        $user->fname    = $request->get('fname');
        $user->lname    = $request->get('lname');
        if ($request->hasFile('avatar')) {
            $userImage = $request->file('avatar');
            $imageName = time() . '_' . $request->get('name') . '.' . $userImage->getClientOriginalExtension();
            $userImage->move('uploads/customers/avatars/', $imageName);
            $user->avatar = '/uploads/' . 'customers' . 'avatars'. '/' . $imageName;
        }        $user->gender   = in_array($request->get('gender'), ['female', 'male']) ? $request->get('gender') : 'male';
        $user->email    = $request->get('email');
        $user->birthday = $request->get('birthday');

        if ($user->save())
            return ControllersService::generateNewResponse(true, 200, 'USER_UPDATED_SUCCESS', $this->handlerMemberInfo($user));

        return ControllersService::generateNewResponse(false, 500, 'USER_UPDATED_FAILED', null);
    }

    // public function requestPasswordReset(Request $request)
    // {
    //     $roles = [
    //         'mobile' => 'required|numeric|digits:9|exists:users,mobile',
    //     ];
    //     $validator = Validator::make($request->all(), $roles);

    //     if (!$validator->fails()) {
    //         $user = Member::where("mobile", $request->get('mobile'))->first();
    //         if (!$user->password_reset_code) {
    //             $user->password_reset_code = Hash::make(1234);
    //             $isSaved = $user->save();
    //             return ControllersService::generateProcessResponse(true, $isSaved ? 'FORGET_PASSWORD_SUCCESS' : 'FORGET_PASSWORD_FAILED');
    //         } else {
    //             return ControllersService::generateProcessResponse(false, 'PASS_RESET_CODE_SENT_BEFORE');
    //         }
    //     } else {
    //         return ControllersService::generateValidationErrorMessage($validator->getMessageBag()->first());
    //     }
    // }

    // public function resetPassword(Request $request)
    // {
    //     $request->validate([
    //         'current_password' => 'required|string|password:user_api',
    //         'new_password' => 'required|string',
    //         'new_password_confirmation' => 'required|string|same:new_password'
    //     ], ['current_password.password' => 'Your current password is not correct']);
    //     $user = Member::find($request->user('user_api')->member_id);
    //     $user->password = Hash::make($request->get('new_password'));
    //     $isSaved = $user->save();
    //     if ($isSaved) {
    //         return ControllersService::generateProcessResponse(true, 'CREATE_SUCCESS');
    //     } else {
    //         return ControllersService::generateProcessResponse(false, 'CREATE_FAILED');
    //     }
    // }

    public function changeEmail(Request $request)
    {
        $member_id = $request->user('user_api')->member_id;

        $roles = [
            'email' => 'required|string|email|unique:member,email,' . $member_id .',member_id',
        ];

        $validator = Validator::make($request->all(), $roles);

        if ( $validator->fails() )
            return ControllersService::generateNewResponse(false, 400, 'USER_UPDATED_FAILED', $validator->getMessageBag()->first());


        $user = Member::find($member_id);
        $user->email = $request->get('email');
        if ($user->save())
            return ControllersService::generateNewResponse(true, 200, 'USER_UPDATED_SUCCESS', $user);

        return ControllersService::generateNewResponse(false, 400, 'ERROR_CREDENTIALS', $user);
    }

    public function changephone(Request $request)
    {
        $member_id = $request->user('user_api')->member_id;

        $roles = [
            'phone' => 'required|numeric|digits:12|unique:member,phone,' . $member_id .',member_id',
        ];
        $validator = Validator::make($request->all(), $roles);
        if ( $validator->fails() )
            return ControllersService::generateNewResponse(false, 400, 'USER_UPDATED_FAILED', $validator->getMessageBag()->first());


        $user = Member::find($member_id);
        $user->phone = $request->post('phone');
        $user->phone_code_valid = SmsController::sendSmsCodeMessage($request->post('phone'), 3);
        if ($user)
        {
            if ($user->save())
                return ControllersService::generateNewResponse(true, 200, 'AUTH_CODE_SENT', ['code' => $user->phone_code_valid, 'new_phone' => $request->get('phone')]);
        }

        return ControllersService::generateNewResponse(false, 400, 'ERROR_CREDENTIALS');
    }

    public function registerID(Request $request)
    {
        
        $registerID = MobileIdDevice::where('member_id', auth()->user()->member_id)->where('vendor_id', $this->vendor_id)->first();

        if (is_null($registerID) OR empty($registerID))
        {
            $registerID = new MobileIdDevice();
            $registerID->member_id   = auth()->user()->member_id;
            $registerID->vendor_id   = $this->vendor_id;
        }
        
        $registerID->mobile_id   = $request->header('mobile_id');
        $registerID->device_type = strtolower($request->header('device_type'));
        $registerID->lang        = $request->header('lang');

        $registerID->save();
        return ControllersService::generateNewResponse(true, 200, 'USER_UPDATED_SUCCESS', $registerID);
    }

    private function generateToken($user, $message)
    {
        $tokenResult = $user->createToken('News-User');
        $token = $tokenResult->accessToken;
        $user->setAttribute('token', $token);
        return ControllersService::generateNewResponse(true, 200, 'REQUEST_SUCCESS', $user);
        // return response()->json([
        //     'status' => true,
        //     'message' => Messages::getMessage($message),
        //     'data' => $user,
        // ]);
    }

    private function handlerMemberInfo($member)
    {
        return [
            'member_id'  => $member->member_id,
            'fname'      => $member->fname,
            'lname'      => $member->lname,
            'avatar'     => $member->avatarUrl,
            'gender'     => $member->gender,
            'phone'      => $member->phone,
            'birthday'   => $member->birthday,
            'email'      => $member->email,
            'last'       => $member->last,
            'isBanned'   => $member->isBanned,
            'phone_code_valid'        => $member->phone_code_valid,
            'phone_code_valid_expire' => $member->phone_code_valid_expire,
            'is_reg_active'           => $member->is_reg_active,
        ];
    }
}
