<?php

namespace App\Http\Controllers\API\branch;

use App\enterprise_member;
use App\Helpers\Messages;
use App\Http\Controllers\API\ControllersService;
use App\Http\Controllers\API\Enterprise\AuthBaseController;
use App\Models\Branch;
use App\Models\Country;
use App\Models\Currency;
use App\Models\Order;
use App\Models\OrderStatus;
use App\Models\Product;
use App\Models\Vendor;
use App\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use App\Models\OrderStatusHistory;
use App\Http\Controllers\API\Enterprise\UserNotificationController;
use App\Models\Member;
use App\user_roles;
use App\Models\table;
use App\Models\TableSession;
use App\Models\tabletime;
use Carbon\Carbon;

class branchApiAuthController extends AuthBaseController
{

    //

    public function login(Request $request)
    {
        $roles = [
            'email' => 'required|string|email|exists:users',
            'password' => 'required',
        ];
        $validator = Validator::make($request->all(), $roles);
        if (!$validator->fails()) {

            $user = User::where("email", $request->get('email'))->with(['vendor', 'branch', 'role'])->first();
            $userRoles = user_roles::where("user_id", $user->id)->with('role')->first();
            if (Hash::check($request->password, $user->password)) {
                $resonseData['id']         = $user->id;
                $resonseData['username']       = $user->username;
                $resonseData['email']       = $user->email;
                $resonseData['branch_name']       = $user->branch->name;
                $resonseData['branch_activity']       = $user->branch->branch_activity;
                $resonseData['vendor_name']       = $user->vendor->name;
                $resonseData['vendor_image']       =  ('https://dashboard.yalago.net/uploads/' . $user->vendor->rest_image);
                $resonseData['role_type']       =  $userRoles->role->display_name;
                $resonseData['token']       = $this->generateToken($user, 'token');
            } else {
                return ControllersService::generateNewResponse(false, 400, 'ERROR_CREDENTIALS', Null);
            }
            if ($user) {

                return ControllersService::generateNewResponse(true, 200, 'LOGGED_IN_SUCCESSFULLY', $resonseData);
                // $this->revokePreviousTokens($user->id);
                return response()->json([
                    'status' => true,
                    'message' => Messages::getMessage('LOGGED_IN_SUCCESSFULLY'),
                    'object' => $resonseData
                ]);
            } else {
                return ControllersService::generateNewResponse(false, 400, 'ERROR_CREDENTIALS', Null);
            }
        }
    }
    public function fcmToken(Request $request)
    {
        $roles = [

            'fcm_token' => 'required',
        ];
        $validator = Validator::make($request->all(), $roles);
        if (!$validator->fails()) {

            $branch = Branch::find(auth()->user('user_api')->branch_id);
            $branch->fcm_token = $request->fcm_token;
            $branch->save();
            return ControllersService::generateNewResponse(true, 200, 'REQUEST_SUCCESS');
        } else {
            return ControllersService::generateNewResponse(false, 400, 'ERROR_CREDENTIALS', Null);
        }
    }
    public function deliveryOrders()
    {
        $orders = Order::where('branch_id', auth()->user()->branch_id)->where('table_id', null)->orderBy('created_at', 'asc')->whereDate('created_at', Carbon::today())
            ->where([['order_status_id', '!=', 8], ['order_status_id', '!=', 7]])
            ->with(['member'])->withCount('order_pools')->get();
        $resonseData = [];
        foreach ($orders as $item => $order) {
            $resonseData[$item]['order_id']   = $order->order_id;
            $resonseData[$item]['order_number']   = $order->order_number;
            $resonseData[$item]['branch_id']   = $order->branch_id;
            $resonseData[$item]['order_status']   = $order->order_status->name;
            $resonseData[$item]['order_status_id']   = $order->order_status_id;
            $resonseData[$item]['order_type']   = $order->order_type;
            $resonseData[$item]['payment_type']   = $order->payment_type;
            $resonseData[$item]['products_count']    = $order->order_pools_count;
            $resonseData[$item]['is_paid']   = $order->is_paid;
            $resonseData[$item]['total']    = $order->total;
            $resonseData[$item]['created_at']    = $order->created_at->timezone('Asia/Riyadh')->format('d-m-Y H:i:s A');
            // 
        }
        return ControllersService::generateNewResponse(true, 200, 'REQUEST_SUCCESS', $resonseData);
    }
    public function AllOrders(Request $request)
    {

        $orders = Order::where('branch_id', auth()->user()->branch_id)->where('table_id', null)
            ->with(['member'])->withCount('order_pools');
        if ($request->orderBy != null) {
            $orders =   $orders->orderBy('created_at', $request->orderBy);
        }
        if ($request->status_id != null) {
            $orders =   $orders->where('order_status_id', $request->status_id);
        }
        if ($request->status == 'active') {
            $orders =  $orders->where([['order_status_id', 3], ['order_status_id', 4], ['order_status_id', 5]]);
        }
        $orders =  $orders->paginate(10);
        $resonseData = [];
        foreach ($orders as $item => $order) {
            $resonseData[$item]['order_id']   = $order->order_id;
            $resonseData[$item]['order_number']   = $order->order_number;
            $resonseData[$item]['branch_id']   = $order->branch_id;
            $resonseData[$item]['order_status']   = $order->order_status->name;
            $resonseData[$item]['order_status_id']   = $order->order_status_id;
            $resonseData[$item]['order_type']   = $order->order_type;
            $resonseData[$item]['payment_type']   = $order->payment_type;
            $resonseData[$item]['products_count']    = $order->order_pools_count;
            $resonseData[$item]['is_paid']   = $order->is_paid;
            $resonseData[$item]['total']    = $order->total;
            $resonseData[$item]['created_at']    = $order->created_at->timezone('Asia/Riyadh')->format('d-m-Y H:i:s A');
            // 
        }
        return ControllersService::generateNewResponse(true, 200, 'REQUEST_SUCCESS', $resonseData);
    }
    public function oneOrder(Request $request, $id)
    {

        $resonseData = [];

        $orders = Order::where([['branch_id', auth()->user()->branch_id], ['order_id', $id]])
            ->orderBy('created_at', 'desc')->with('order_pools');

        $orders = $orders->first();

        $resonseData['order_id']  = $orders->order_id;
        $resonseData['order_number']  = $orders->order_number;
        $resonseData['total']  = $orders->total;
        $resonseData['created_at']  = $orders->created_at->timezone('Asia/Riyadh')->format('d-m-Y H:i:s A');
        $resonseData['status_id']  = $orders->order_status_id;
        $resonseData['order_status']  = $orders->order_status->name;
        $resonseData['order_type']   = $orders->order_type;


        foreach ($orders->order_pools as $i => $pool) {
            $resonseData['order_pool'][$i]['pool_id']   = $pool->order_pool_id;
            $resonseData['order_pool'][$i]['order_id']   = $pool->order_id;
            $resonseData['order_pool'][$i]['product_id']   = $pool->meal_id;
            $resonseData['order_pool'][$i]['product_name']   = $pool->product->name;
            $resonseData['order_pool'][$i]['product_image']   = $pool->product->image;
            $resonseData['order_pool'][$i]['product_desc']   = $pool->product->desc;
            $resonseData['order_pool'][$i]['product_quantity']   = $pool->meal_quantity;
            $resonseData['order_pool'][$i]['one_product_price']   = $pool->one_meal_price;
            foreach ($pool->poolAddons as $e => $addon) {
                $resonseData['order_pool'][$i]['addons'][$e]['addon_name']   = $addon->productAddon->itemInfo->name;
            }
        }

        return ControllersService::generateNewResponse(true, 200, 'REQUEST_SUCCESS', $resonseData);
    }



    public function Table()
    {

        $allTables = table::where('branch_id', auth()->user('user_api')->branch_id)->where('order_status', '!=', 'closed');
        $tableSessionAll = TableSession::whereIn('table_id', $allTables->pluck('id'))->where('is_closed', 0)->orderBy('created_at', 'desc')->get();
        $orderTotals = $allTables->withCount(['orders' => function ($query) use ($tableSessionAll) {
            $query->where('order_status_id', '!=', [10, 7, 8])
                ->whereIn('table_session_id', $tableSessionAll->pluck('id'))
                ->orderBy('created_at', 'desc');
        }])
            ->with(['orders' => function ($query) use ($tableSessionAll) {
                $query->where('order_status_id', '!=', [10, 7, 8])
                    ->whereIn('table_session_id', $tableSessionAll->pluck('id'))
                    ->orderBy('created_at', 'desc')->select('order_id', 'table_id', 'total', 'order_number');
            }, 'tabletime' => function ($query) use ($tableSessionAll) {
                $query->whereIn('table_session_id', $tableSessionAll->pluck('id'));
            }])->get();
        $orderTotal =  $orderTotals->pluck('orders');

        foreach ($orderTotals as $item => $table) {


            $resonseData[$item]['table_id']   = $table->id;
            $resonseData[$item]['table_number']   = $table->tableNumber;
            $resonseData[$item]['branch_id']   = $table->branch_id;
            $resonseData[$item]['table_status']   = $table->order_status;
            $resonseData[$item]['order_count']    = $table->orders_count;





            foreach ($table->orders as $order) {

                $resonseData[$item]['total_orders']   = $order->where('table_id', $table->id)->whereIn('table_session_id', $tableSessionAll->pluck('id'))->sum('total');
            }
            foreach ($table->tabletime as $i => $tabletime) {
                $resonseData[$item]['tabletime'][$i]['scan_time']   = $tabletime->scan_time;
                $resonseData[$item]['tabletime'][$i]['order_time']   = $tabletime->order_time;
                $resonseData[$item]['tabletime'][$i]['orderPick']   = $tabletime->orderPick;
                $resonseData[$item]['tabletime'][$i]['preparation_time']   = $tabletime->preparation_time;
                $resonseData[$item]['tabletime'][$i]['onTable']   = $tabletime->onTable;
                $resonseData[$item]['tabletime'][$i]['close_time']   = $tabletime->close_time;
            }
        }
        return ControllersService::generateNewResponse(true, 200, 'REQUEST_SUCCESS', $resonseData);

        // return ControllersService::generateNewResponse(true, 200, 'REQUEST_SUCCESS', $resonseData);
    }

    public function TableOrders(Request $request)
    {
        $table_id = $request->table_id;
        $tableSessionAll = TableSession::where('table_id', $table_id)->where('is_closed', 0)->orderBy('created_at', 'desc')->get();
        $resonseData = [];
        $orders = Order::where('branch_id', auth()->user('user_api')->branch_id)->whereIn('table_session_id', $tableSessionAll->pluck('id'))
            ->orderBy('created_at', 'desc')
            ->where('order_status_id', '!=', 8)->where('order_status_id', '!=', 7)->where('order_status_id', '!=', 10)->with('order_pools');
        $orderTotal = $orders->sum('total');
        $orders = $orders->get();
        foreach ($orders as $item => $order) {
            $resonseData[$item]['total_orders'] = $orderTotal;
            $resonseData[$item]['order_id']  = $order->order_id;
            $resonseData[$item]['order_number']  = $order->order_number;
            $resonseData[$item]['table_id']   = $order->table_id;
            $resonseData[$item]['table_number']   = $order->table->tableNumber;
            $resonseData[$item]['total']  = $order->total;
            $resonseData[$item]['created_at']  = $order->created_at->timezone('Asia/Riyadh')->format('d-m-Y H:i:s A');
            $resonseData[$item]['status_id']  = $order->order_status_id;
            if ($order->order_status_id == 3) {
                $resonseData[$item]['order_status']  = 'Order Received';
            } elseif ($order->order_status_id == 4) {
                $resonseData[$item]['order_status']  = 'preparation';
            } elseif ($order->order_status_id == 5) {
                $resonseData[$item]['order_status']  = 'onTable';
            } elseif ($order->order_status_id == 6) {
                $resonseData[$item]['order_status']  = 'Ordered';
            } elseif ($order->order_status_id == 10) {
                $resonseData[$item]['order_status']  = 'Done';
            }
            foreach ($order->order_pools as $i => $pool) {
                $resonseData[$item]['order_pool'][$i]['pool_id']   = $pool->order_pool_id;
                $resonseData[$item]['order_pool'][$i]['order_id']   = $pool->order_id;
                $resonseData[$item]['order_pool'][$i]['product_id']   = $pool->meal_id;
                $resonseData[$item]['order_pool'][$i]['product_name']   = $pool->product->name;
                $resonseData[$item]['order_pool'][$i]['product_image']   = $pool->product->image;
                $resonseData[$item]['order_pool'][$i]['product_desc']   = $pool->product->desc;
                $resonseData[$item]['order_pool'][$i]['product_quantity']   = $pool->meal_quantity;
                $resonseData[$item]['order_pool'][$i]['one_product_price']   = $pool->one_meal_price;
                foreach ($pool->poolAddons as $e => $addon) {
                    $resonseData[$item]['order_pool'][$i]['addons'][$e]['addon_name']   = $addon->productAddon->itemInfo->name;
                }
            }
        }
        return ControllersService::generateNewResponse(true, 200, 'REQUEST_SUCCESS', $resonseData);
    }
    public function tables()
    {
        $tables = table::where('branch_id', auth()->user('user_api')->branch_id)->get();

        foreach ($tables as $item => $table) {
            $resonseData[$item]['table_id']   = $table->id;
            $resonseData[$item]['table_number']   = $table->tableNumber;
            $resonseData[$item]['branch_id']   = $table->branch_id;
            $resonseData[$item]['table_status']   = $table->order_status;
        }
        return ControllersService::generateNewResponse(true, 200, 'REQUEST_SUCCESS', $resonseData);
    }

    public function changeTableOrder(Request $request)
    {
        $id = $request->get('table_id');
        $order_id = $request->order_id;
        $branch_id = auth()->user('user_api')->branch_id;
        $order = Order::find($order_id);
        $tablechange = table::where('branch_id', $branch_id)->where('id', $order->table_id)->first();
        $TableSessionAll = TableSession::where('table_id', $tablechange->id)->where('is_closed', 0)->orderBy('created_at', 'desc')->first();
        $tableOpen = table::where('branch_id', $branch_id)->where('id', $id)->first();
        $tableOpen->order_status = 'orderPick';
        $tableOpen->save();
        $TableSession = new TableSession;
        $TableSession->table_id = $id;
        $TableSession->guest_count = 1;
        $TableSession->save();
        $order->table_id = $id;
        $order->table_session_id = $TableSession->id;
        $order->save();
        $orders = Order::where('branch_id', $branch_id)
            ->where('table_id', $tablechange->id)
            ->where('table_session_id', $TableSessionAll->id)
            ->orderBy('order_id', 'DESC')
            ->count();
        if ($orders == 0) {
            $tablechange->order_status = 'closed';
            $tablechange->save();
        }
        return ControllersService::generateNewResponse(true, 200, 'REQUEST_SUCCESS');
    }
    public function changeTable(Request $request)
    {
        $branch_id = auth()->user('user_api')->branch_id;
        $table_id_close = $request->get('table_id_close');
        $table_id_open = $request->get('table_id_open');
        $tableClose = table::where('branch_id', $branch_id)->where('id', $table_id_close)->first();
        $tableOpen = table::where('branch_id', $branch_id)->where('id', $table_id_open)->first();
        $tableOpen->order_status = $tableClose->order_status;
        $tableOpen->visit_count = $tableClose->visit_count;
        $tableOpen->save();
        $TableSessionAll = TableSession::where('table_id', $tableClose->id)->where('is_closed', 0)->orderBy('created_at', 'desc')->first();

        $tableTime = tabletime::where('table_session_id', $TableSessionAll->id)->first();

        // $tableTime->table_id = $table_id_open;
        // $tableTime->save();
        $orders = Order::where('branch_id', $branch_id)
            ->where('table_id', $table_id_close)
            ->where('table_session_id', $TableSessionAll->id)
            ->orderBy('order_id', 'DESC')
            ->get();
        $TableSessionAll->table_id = $table_id_open;
        $TableSessionAll->save();
        foreach ($orders as $order) {
            $order->table_id = $table_id_open;
            $order->save();
        }
        $tableClose->order_status = 'closed';
        $tableClose->save();
        return ControllersService::generateNewResponse(true, 200, 'REQUEST_SUCCESS');
    }
    public function orderStatusTables(Request $request)
    {
        $status = OrderStatus::where('order_status_id', '!=',  8)
            ->where([
                ['order_status_id', '!=',  9], ['order_status_id', '!=',  7],
                ['order_status_id', '!=',  2], ['order_status_id', '!=',  3],
                ['order_status_id', '!=',  6]
            ])->get();

        $statu      = null;
        foreach ($status as $item => $value) {
            $statu[$item]['order_status_id']   = $value->order_status_id;
            if ($value->order_status_id == 4) {
                $statu[$item]['status_name']  = 'Preparation';
            } elseif ($value->order_status_id == 5) {
                $statu[$item]['status_name']  = 'On Table';
            } elseif ($value->order_status_id == 10) {
                $statu[$item]['status_name']  = 'Done';
            }
        }
        return ControllersService::generateNewResponse(true, 200, 'REQUEST_SUCCESS', $statu);
    }
    public function closeOrderStatusTables(Request $request)
    {

        // $validator = Validator($request->all(), [
        //     'data' => 'required',
        // ]);
        // if (!$validator->fails()) {
        $data  = $request->all();
        $order_id = $data['orderInfo']['call_number'];
        $order = order::find($order_id);
        if ($order) {
            $table = table::find($order->table_id);
            $tableTime = tabletime::where('table_id', $order->table_id)->orderBy('created_at', 'desc')->first();
            $tableTime->close_time = \Carbon\Carbon::now();
            $tableTime->save();
            $table->order_status = 'closed';
            $table->save();
            Order::where('order_id', $order_id)->update(['order_status_id' => 10, 'is_paid' => 1]);
            return ControllersService::generateNewResponse(true, 200, 'REQUEST_SUCCESS');
        }
    }
    public function changeOrderStatusTables(Request $request)
    {
        $status    = $request->status;
        $order_id  = $request->order_id;
        $order = order::find($order_id);
        $table = table::find($order->table_id);
        $tableTime = tabletime::where('table_id', $table->id)->orderBy('created_at', 'desc')->first();
        if ($status == '3') {
            $tableTime->orderPick = \Carbon\Carbon::now();
            $tableTime->save();
            $table->order_status = 'orderPick';
            $table->save();
            // orders accepted
            // Order::where('table_id', $table_id)->update(['order_status_id' => 3]);
            Order::where('order_id', $order_id)->where('order_status_id', 6)->update(['order_status_id' => 3]);
        }
        if ($status == '4') {
            $tableTime->orderPick = \Carbon\Carbon::now();
            $tableTime->preparation_time = \Carbon\Carbon::now();
            $tableTime->save();
            $table->order_status = 'preparation';
            $table->save();
            // orders is preparation && update all orders
            // Order::where('table_id', $table_id)->update(['order_status_id' => 4]);
            Order::where('order_id', $order_id)->whereIn('order_status_id', [3, 6])->update(['order_status_id' => 4]);
            // update all orders
        }
        if ($status == '5') {
            $tableTime->onTable = \Carbon\Carbon::now();
            $tableTime->save();
            Order::where('order_id', $order_id)->where('order_status_id', 4)->update(['order_status_id' => 5, 'is_paid' => 1]);
            $table->order_status = 'onTable';
            $table->save();
        }
        if ($status == '10') {
            $tableTime->onTable = \Carbon\Carbon::now();
            $tableTime->save();
            Order::where('order_id', $order_id)->where('order_status_id', 5)->update(['order_status_id' => 10, 'is_paid' => 1]);
            $TableSessionAll = TableSession::where('table_id', $order->table_id)->where('is_closed', 0)->orderBy('created_at', 'desc')->get();
            $orderTables = Order::where('table_id', $order->table_id)->where('table_session_id', $TableSessionAll->pluck('id'))->where('order_status_id', '!=', 10)->get();
            if ($orderTables->count() == 0) {
                $table = table::find($order->table_id);
                $table->order_status = 'closed';
                $table->save();
            }
        }
        if ($status == 'closed') {
            $tableTime->close_time = \Carbon\Carbon::now();
            $tableTime->save();
            $table->order_status = 'closed';
            $table->save();
            // orders is paid && orders is compeleted && update all orders
            // Order::where('table_id', $table_id)->update(['order_status_id' => 8, 'is_paid' => 1]);
            Order::where('order_id', $order_id)->update(['order_status_id' => 8, 'is_paid' => 1]);
            // close table session
            // TableSession::where('table_id', $table_id)->update(['is_closed' => 1, 'closed_at' => \Carbon\Carbon::now()]);
        }
        return ControllersService::generateNewResponse(true, 200, 'REQUEST_SUCCESS');
    }

    public function getOrder()
    {
        $user = auth()->user('user_api')->branch_id;
        $orders = Order::where('branch_id', $user)->with('address')->with('enterprise_member')->orderBy('order_id', 'desc')->with('addressAPI')->paginate(10);

        $pagination['total'] = $orders->total();
        $pagination['count'] = $orders->count();
        $pagination['hasMorePages'] = $orders->hasMorePages();
        $pagination['currentPage'] = $orders->currentPage();
        $pagination['firstItem'] = $orders->firstItem();
        $pagination['last_page_id'] = $orders->lastPage();
        $pagination['per_page'] = $orders->perPage();
        $pagination['nextPageUrl'] = $orders->nextPageUrl();
        $pagination['onFirstPage'] = $orders->onFirstPage();
        $pagination['previousPageUrl'] = $orders->previousPageUrl();

        $order      = null;
        foreach ($orders as $item => $value) {
            $order[$item]['order_id']   = $value->order_id;
            $order[$item]['address_id']   = $value->address_id;
            $order[$item]['mbr_id']   = $value->mbr_id;
            $order[$item]['vendor_id']   = $value->vendor_id;
            $order[$item]['branch_id']   = $value->branch_id;
            $order[$item]['coupon_id']   = $value->coupon_id;
            $order[$item]['order_number']   = $value->order_number;
            $order[$item]['address']   = $value->addressAPI;

            $order[$item]['delivery_cost']   = $value->delivery_cost;
            $order[$item]['order_status_id']   = $value->order_status_id;
            $order[$item]['order_date']   = $value->order_date;
            $order[$item]['latitude']   = $value->latitude;
            $order[$item]['longitude']   = $value->longitude;
            $order[$item]['total']   = $value->total;
            $order[$item]['total_without_discount']   = $value->total_without_discount;
            $order[$item]['discount']   = $value->discount;
            $order[$item]['payment_type']   = $value->payment_type;
            $order[$item]['client_name']   = $value->enterprise_member->fname;
            $order[$item]['client_phone']   = $value->enterprise_member->phone ?? '';
            $order[$item]['tracking_delivery_link']   = null;
            $order[$item]['tracking_customer_link']   = null;
            $order[$item]['order_status']   = $value->order_statusAPi;
            // foreach ($value->order_status as $e => $values) {
            //     $order[$item]['order_status'][$e]['status_name']    =   $values->status_name;
            //     $order[$item]['order_status'][$e]['done_time']    =   $values->done_time;
            //     $order[$item]['order_status'][$e]['status_time']    =   $values->status_time;
            // }



        }
        $response = [];
        $response['paginate'] = $pagination;
        $response['orders'] = $order;


        return ControllersService::generateNewResponse(true, 200, 'REQUEST_SUCCESS', $response);
    }

    public function getOrderById(Request $request)
    {
        $user = auth()->user('user_api')->branch_id;
        $branch = Branch::find($user);
        $vendor_id = $branch->vendor_id;
        $vendor = Vendor::find($vendor_id);
        $country_id = $vendor->country_id;
        $currency_id = $vendor->currency_id;
        $countris = Country::where('country_id', $country_id)->get();
        foreach ($countris as $item => $value) {
            $country[$item]['country_code']   = $value->country_code;
            $country[$item]['name']   = $value->name;
        }
        $currencies = Currency::where('id', $currency_id)->get();
        foreach ($currencies as $item => $value) {
            $currency[$item]['country_code']   = $value->code;
            $currency[$item]['name']   = $value->name;
        }

        $order_id = $request->order_id;
        $orders = Order::where('order_number', $order_id)->with('enterprise_member')->with('addressAPI')->with('order_status')->first();
        if (is_null($orders)) {
            return ControllersService::generateNewResponse(true, 200, 'REQUEST_SUCCESS', $orders);
        }

        $order      = null;

        $order['order_id']   = $orders->order_id;
        $order['address_id']   = $orders->address_id;
        $order['mbr_id']   = $orders->mbr_id;
        $order['vendor_id']   = $orders->vendor_id;
        $order['branch_id']   = $orders->branch_id;
        $order['coupon_id']   = $orders->coupon_id;
        $order['order_number']   = $orders->order_number;
        $order['address']   = $orders->addressAPI;
        $order['delivery_cost']   = $orders->delivery_cost;
        $order['order_status_id']   = $orders->order_status_id;
        $order['order_date']   = $orders->order_date;
        $order['latitude']   = $orders->latitude;
        $order['longitude']   = $orders->longitude;
        $order['total']   = $orders->total;
        $order['total_without_discount']   = $orders->total_without_discount;
        $order['discount']   = $orders->discount;
        $order['payment_type']   = $orders->payment_type;
        $order['client_name']   = $orders->enterprise_member->fname;
        $order['client_phone']   = $orders->enterprise_member->phone;
        $order['tracking_delivery_link']   = null;
        $order['tracking_customer_link']   = null;
        $order['order_status']   = $orders->order_statusAPi;
        $products = $orders->order_pools;
        foreach ($products as $i => $product) {
            $pureProduct = Product::where('product_id', $product->meal_id)->first();
            $order['products'][$i]['product_name']       = $pureProduct->name;
            $order['products'][$i]['product_desc']       = $pureProduct->desc;
            $order['products'][$i]['quantity']           = $product->meal_quantity;
            $order['products'][$i]['one_product_price']  = $product->one_meal_price;
            $order['products'][$i]['price_with_addons']  = $product->price_with_addons;
            $order['products'][$i]['custom_meal_addons'] = $product->custom_meal_addons;
            $order['products'][$i]['image']              = $pureProduct->image;
        }

        return ControllersService::generateNewResponse(true, 200, 'REQUEST_SUCCESS', ['country' => $country, 'currency' => $currency, 'order' => $order]);
    }


    public function orderStatus(Request $request)
    {
        $status = OrderStatus::where([
            ['order_status_id', '!=',  4], ['order_status_id', '!=',  10],
            ['order_status_id', '!=',  9]
        ])->orderBy('sort', 'asc')->get();
        $statu      = null;
        foreach ($status as $item => $value) {
            $statu[$item]['order_status_id']   = $value->order_status_id;
            $statu[$item]['status_name']   = $value->status_name;
            $statu[$item]['status_time']   = $value->status_time;
        }
        return ControllersService::generateNewResponse(true, 200, 'REQUEST_SUCCESS', $statu);
    }
    public function updateStatus(Request $request, $id)
    {

        $order = Order::where('order_id', $id)->first();

        $order->order_status_id = $request->status_id;
        // $order->order_status_id = $request->time;
        $isSave = $order->save();
        $status = OrderStatus::find($request->status_id);

        $status_order = $status->status_order;

        $orderStatus = new OrderStatusHistory();
        $orderStatus->status_id = $request->status_id;
        $orderStatus->order_id = $order->order_id;
        $orderStatus->orderStatus = $status_order;

        $orderStatus->save();

        $member = $order->mbr_id;
        $users = Member::find($member);
        if ($users != null) {
            $fcm_token = $users->fcm_token;
            if ($fcm_token != null) {
                $order_id = $order->order_id;
                $vendor_id =  null;
                $product_id =  null;
                $lang = $users->lang;

                if ($request->status_id == 3) {
                    if ($lang == 'ar') {
                        $userNotificationController = new UserNotificationController();
                        $userNotificationController->sendNotification('طلب', 'تم ارسال الطلب ', $fcm_token, $order_id, $vendor_id, $product_id);
                    } elseif ($lang == 'en') {
                        $userNotificationController = new UserNotificationController();
                        $userNotificationController->sendNotification('order', 'order send', $fcm_token, $order_id, $vendor_id, $product_id);
                    }
                } elseif ($request->status_id == 4) {
                    if ($lang == 'ar') {
                        $userNotificationController = new UserNotificationController();
                        $userNotificationController->sendNotification('طلب', 'الطلب في المطبح ', $fcm_token, $order_id, $vendor_id, $product_id);
                    } elseif ($lang == 'en') {
                        $userNotificationController = new UserNotificationController();
                        $userNotificationController->sendNotification('order', 'order in the kitchen', $fcm_token, $order_id, $vendor_id, $product_id);
                    }
                } elseif ($request->status_id == 5) {
                    if ($lang == 'ar') {
                        $userNotificationController = new UserNotificationController();
                        $userNotificationController->sendNotification('طلب', 'الطلب الخاص بك في الطريق إليك', $fcm_token, $order_id, $vendor_id, $product_id);
                    } elseif ($lang == 'en') {
                        $userNotificationController = new UserNotificationController();
                        $userNotificationController->sendNotification('order', 'Your request is on the way to you', $fcm_token, $order_id, $vendor_id, $product_id);
                    }
                } elseif ($request->status_id == 8) {
                    if ($lang == 'ar') {
                        $userNotificationController = new UserNotificationController();
                        $userNotificationController->sendNotification('طلب', 'تم توصيل الطلب إليك بنجاح', $fcm_token, $order_id, $vendor_id, $product_id);
                    } elseif ($lang == 'en') {
                        $userNotificationController = new UserNotificationController();
                        $userNotificationController->sendNotification('order', 'The order has been successfully delivered to you', $fcm_token, $order_id, $vendor_id, $product_id);
                    }
                }
            }
            if ($isSave) {
                return ControllersService::generateNewResponse(true, 200, 'CREATE_SUCCESS', null);
            } else {
                return ControllersService::generateNewResponse(false, 500, 'CREATE_FAILED', null);
            }
        }
    }
    private function generateToken($user, $message)
    {
        $tokenResult = $user->createToken('News-User');
        return $token = $tokenResult->accessToken;
        $user->setAttribute('token', $token);
        $realTimeOptions = [
            'providor' => 'pusher',
            'key' => '877e85f3c7b7146b166b',
            'channel' => 'newOrdersDigitalMenu',
            'event' => 'realtimeBranchID_' . $user->branch_id,
            'cluster' => 'eu',
        ];
        $response = $user;
        $response['real_time_options'] = $realTimeOptions;
        return ControllersService::generateNewResponse(true, 200, 'REQUEST_SUCCESS', $response);
        // return response()->json([
        //     'status' => true,
        //     'message' => Messages::getMessage($message),
        //     'data' => $user,
        // ]);
    }
}
