<?php

namespace App\Http\Middleware\Dashboard\Branch;

use Closure;

use Illuminate\Support\Facades\Redirect;
use Auth;

class CreateBranch
{
    public function handle($request, Closure $next)
    {
        if(Auth::check())
        {
            if(Auth::user()->hasPermission('create_branch'))
            {
                return $next($request);
            }
            else 
            {
                return Redirect::route('dashboard.error_pages.not_permissions',['locale'=>app()->getLocale()]);
            }
        }
        else
        {
            return Redirect::route('dashboard.auth.login',['locale'=>app()->getLocale()]);
        }
    }
}
